// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_HAVOK_ASSEMBLY_EXCLUDE_FILE

#pragma once

#include <Geometry/Collide/DataStructures/Planar/Geometry/hkcdPlanarGeometry.h>

/// Utility to compute the convex hull of a set of points given in fixed precision
class HK_EXPORT_COMMON hkcdPlanarGeometryConvexHullUtil
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY, hkcdPlanarGeometryConvexHullUtil);

    public:

        /// Builds the convex hull from the given set of points. Returns the number of hull dimensions or -1 if it failed to compute the hull
        static int HK_CALL build(   const hkAabb& coordinateConversionAabb, _In_reads_(numVerticesIn) const hkVector4* verticesIn, const int numVerticesIn,
            hkRefPtr<hkcdPlanarGeometry>& convexHullOut, _Inout_opt_ hkcdPlanarEntityDebugger* debugger = HK_NULL);
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
