// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_HAVOK_ASSEMBLY_EXCLUDE_FILE
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#include <Common/Base/Math/LargeInt/hkLargeIntTypes.h>

/// Arithmetic operations error calculator
struct hkcdMathErrorBoundsCalculator
{
    HK_DECLARE_CLASS(hkcdMathErrorBoundsCalculator, New);

    /// Returnsthe unit in the last place for the given number, x
    ///     x       = 1.M * 2^E
    ///     ulpOut  = 1.0 * 2^(E - numMantissaBits)
    static HK_INLINE void HK_CALL ulp(hkVector4dParameter xIn, hkVector4d& ulpOut);
    static HK_INLINE void HK_CALL ulp(hkSimdDouble64Parameter xIn, hkSimdDouble64& ulpOut);

    /// Scalar
    struct Scalar
    {
        HK_DECLARE_CLASS(Scalar, New);

        /// Adds the scalars
        HK_INLINE void setAdd(const Scalar& vA, const Scalar& vB);

        /// Multiplies the vectors
        HK_INLINE void setMul(const Scalar& vA, const Scalar& vB);

        /// Sets this = 1 / x
        HK_INLINE void setReciprocal(const Scalar& x);

        /// Sets this = x / y
        HK_INLINE void setDiv(const Scalar& x, const Scalar& y);

        hkSimdDouble64 m_val;   ///< The value
        hkSimdDouble64 m_err;   ///< The error
    };

    /// Vector
    struct Vector
    {
        HK_DECLARE_CLASS(Vector, New);

        /// Sets the vector value and computes the error
        HK_INLINE void set(hkVector4dParameter x);

        /// Sets the vector value
        HK_INLINE void set(const Scalar& x, const Scalar& y, const Scalar& z, const Scalar& w);

        /// Adds the vectors
        HK_INLINE void setAdd(const Vector& vA, const Vector& vB);

        /// Multiplies the vectors
        HK_INLINE void setMul(const Vector& vA, const Vector& vB);

        /// Permutes the vector
        template <hkVectorPermutation::Permutation p>
        HK_INLINE void setPermutation(const Vector& x);

        /// Negates the vector
        HK_INLINE void setNeg(const Vector& x);

        /// Subtracts the vectors
        HK_INLINE void setSub(const Vector& vA, const Vector& vB);

        /// Computes the cross produt
        HK_INLINE void setCross(const Vector& vA, const Vector& vB);

        /// Computes the dot product
        template <int N>
        static HK_INLINE void HK_CALL dot(const Vector& vA, const Vector& vB, Scalar& dotAB);

        /// Returns the I-th component
        template <int I>
        HK_INLINE void getComponent(Scalar& componentOut) const;

        /// Sign flip
        HK_INLINE void setFlipSign(const Vector& v, hkVector4dComparisonParameter m);

        hkVector4d m_val;   ///< The value
        hkVector4d m_err;   ///< The absolute error
    };
};

#include <Geometry/Collide/DataStructures/Planar/Utils/hkcdMathErrorBoundsCalculator.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
