// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#ifndef __HAVOK_PARSER__



//
//  Accessors (Node Storage)

HK_INLINE const hkcdPlanarSolid::Node& hkcdPlanarSolid::NodeStorage::getNode(NodeId nodeId) const
{
    return m_storage[nodeId.value()];
}

HK_INLINE hkcdPlanarSolid::Node& hkcdPlanarSolid::NodeStorage::accessNode(NodeId nodeId)
{
    return m_storage[nodeId.value()];
}

HK_INLINE const hkcdPlanarSolid::NodeStorage::Aabb& hkcdPlanarSolid::NodeStorage::getNodeAabb(NodeId nodeId) const
{
    return m_aabbs[getNode(nodeId).m_aabbId.value()];
}

HK_INLINE hkcdPlanarSolid::NodeStorage::Aabb& hkcdPlanarSolid::NodeStorage::accessNodeAabb(NodeId nodeId)
{
    return m_aabbs[getNode(nodeId).m_aabbId.value()];
}

HK_INLINE const hkcdPlanarSolid::NodeStorage::Aabb& hkcdPlanarSolid::NodeStorage::getNodeAabb(AabbId aabbId) const
{
    return m_aabbs[aabbId.value()];
}

HK_INLINE hkcdPlanarSolid::NodeStorage::Aabb& hkcdPlanarSolid::NodeStorage::accessNodeAabb(AabbId aabbId)
{
    return m_aabbs[aabbId.value()];
}

//
//  Allocation (Node Storage)

HK_INLINE hkcdPlanarSolid::NodeId hkcdPlanarSolid::NodeStorage::allocate()
{
    // Check if space
    if ( m_firstFreeNodeId.isValid() )
    {
        const NodeId ret    = m_firstFreeNodeId;
        m_firstFreeNodeId   = getNode(m_firstFreeNodeId).m_nextFreeNodeId;
        accessNode(ret).m_nextFreeNodeId = NodeId::invalid();
        return ret;
    }
    else
    {
        m_storage.expandOne().m_nextFreeNodeId = NodeId::invalid();
        return NodeId(m_storage.getSize() - 1);
    }
}

HK_INLINE hkcdPlanarSolid::AabbId hkcdPlanarSolid::NodeStorage::allocateAabb()
{
    m_aabbs.expandOne();
    return AabbId(m_aabbs.getSize() - 1);
}

HK_INLINE void hkcdPlanarSolid::NodeStorage::clear()
{
    m_storage.clear();
    m_aabbs.clear();
    m_firstFreeNodeId       = NodeId::invalid();
}

HK_INLINE int hkcdPlanarSolid::NodeStorage::getCapacity() const
{
    return m_storage.getSize();
}

HK_INLINE void hkcdPlanarSolid::NodeStorage::release(NodeId nodeId)
{
    accessNode(nodeId).m_nextFreeNodeId = m_firstFreeNodeId;
    accessNode(nodeId).clear();
    m_firstFreeNodeId = nodeId;
}

//
//  Other (Node storage)

HK_INLINE void hkcdPlanarSolid::NodeStorage::swapStorage(hkArray<Node>& nodes, hkArray<Aabb>& aabbs)
{
    m_storage.swap(nodes);
    m_aabbs.swap(aabbs);
    m_firstFreeNodeId       = NodeId::invalid();
}

HK_INLINE void hkcdPlanarSolid::NodeStorage::compact()
{
    m_storage.optimizeCapacity(0, true);
    m_aabbs.optimizeCapacity(0, true);
    m_firstFreeNodeId       = NodeId::invalid();
}

//
//  Gets the node having the given Id.

HK_INLINE const hkcdPlanarSolid::Node& hkcdPlanarSolid::getNode(NodeId nodeId) const    {   return m_nodes->getNode(nodeId);    }
HK_INLINE hkcdPlanarSolid::Node& hkcdPlanarSolid::accessNode(NodeId nodeId)         {   return m_nodes->accessNode(nodeId); }

//
//  Returns the nodes

HK_INLINE _Ret_maybenull_ const hkcdPlanarSolid::NodeStorage* hkcdPlanarSolid::getNodes() const
{
    return m_nodes;
}

HK_INLINE _Ret_maybenull_ hkcdPlanarSolid::NodeStorage* hkcdPlanarSolid::accessNodes()
{
    return m_nodes;
}

//
//  Returns the collection of planes used by this solid

HK_INLINE _Ret_maybenull_ hkcdPlanarGeometryPlanesCollection* hkcdPlanarSolid::accessPlanesCollection()         {   return const_cast<hkcdPlanarGeometryPlanesCollection*>(m_planes.val()); }
HK_INLINE _Ret_maybenull_ const hkcdPlanarGeometryPlanesCollection* hkcdPlanarSolid::getPlanesCollection() const    {   return m_planes;    }

//
//  Returns true if the tree is valid

HK_INLINE bool hkcdPlanarSolid::isValid() const
{
    return m_rootNodeId.isValid();
}

//
//  Returns true if the tree represent the empty set

HK_INLINE bool hkcdPlanarSolid::isEmpty() const
{
    return (isValid() && getNodeLabel(m_rootNodeId) == NODE_TYPE_OUT);
}

//
//  Returns true if the given node is internal

HK_INLINE bool hkcdPlanarSolid::isInternal(NodeId nodeId) const
{
    if ( nodeId.isValid() )
    {
        const Node& node = getNode(nodeId);
        return node.isAllocated() && (node.m_type == NODE_TYPE_INTERNAL);
    }
    return false;
}

//
//  Returns the Id of the root node

HK_INLINE const hkcdPlanarSolid::NodeId hkcdPlanarSolid::getRootNodeId() const
{
    return m_rootNodeId;
}

//
//  Returns the label of a given leaf node

HK_INLINE hkcdPlanarSolid::NodeTypes hkcdPlanarSolid::getNodeLabel(NodeId nodeId) const
{
    const Node& node = getNode(nodeId);
    return (hkcdPlanarSolid::NodeTypes)node.m_type;
}

//
//  Creates a new internal node

HK_INLINE hkcdPlanarSolid::NodeId hkcdPlanarSolid::createNode(PlaneId splitPlaneId, NodeId leftChild, NodeId rightChild)
{
    const NodeId nodeId = m_nodes->allocate();
    Node& node = accessNode(nodeId);

    node.m_planeId      = splitPlaneId;
    node.m_left         = leftChild;
    node.m_right        = rightChild;
    node.m_type         = NODE_TYPE_INTERNAL;
    node.m_data         = 0;
    node.m_aabbId       = AabbId::invalid();
    node.m_material     = Material::invalid();
    return nodeId;
}

//
// Default nodes accessors

HK_INLINE hkcdPlanarSolid::NodeId hkcdPlanarSolid::createInsideNode(NodeId parentId)
{
    NodeId inNodeId     = m_nodes->allocate();
    Node& nodeIn        = accessNode(inNodeId);
    nodeIn.m_left       = NodeId::invalid();
    nodeIn.m_right      = NodeId::invalid();
    nodeIn.m_type       = NODE_TYPE_IN;
    nodeIn.m_planeId    = PlaneId::invalid();
    nodeIn.m_parent     = parentId;
    nodeIn.m_data       = 0;
    nodeIn.m_aabbId     = AabbId::invalid();
    nodeIn.m_material   = Material::invalid();
    return inNodeId;
}

HK_INLINE hkcdPlanarSolid::NodeId hkcdPlanarSolid::createOutsideNode(NodeId parentId)
{
    NodeId outNodeId    = m_nodes->allocate();
    Node& nodeOut       = accessNode(outNodeId);
    nodeOut.m_left      = NodeId::invalid();
    nodeOut.m_right     = NodeId::invalid();
    nodeOut.m_type      = NODE_TYPE_OUT;
    nodeOut.m_planeId   = PlaneId::invalid();
    nodeOut.m_parent    = parentId;
    nodeOut.m_data      = 0;
    nodeOut.m_aabbId    = AabbId::invalid();
    nodeOut.m_material  = Material::invalid();
    return outNodeId;
}

HK_INLINE hkcdPlanarSolid::NodeId hkcdPlanarSolid::createUnknownNode(NodeId parentId)
{
    NodeId unknownNodeId    = m_nodes->allocate();
    Node& nodeUnknown       = accessNode(unknownNodeId);
    nodeUnknown.m_left      = NodeId::invalid();
    nodeUnknown.m_right     = NodeId::invalid();
    nodeUnknown.m_type      = NODE_TYPE_UNKNOWN;
    nodeUnknown.m_planeId   = PlaneId::invalid();
    nodeUnknown.m_parent    = parentId;
    nodeUnknown.m_data      = 0;
    nodeUnknown.m_aabbId    = AabbId::invalid();
    nodeUnknown.m_material  = Material::invalid();
    return unknownNodeId;
}

//
//  Sets the root node

HK_INLINE void hkcdPlanarSolid::setRootNode(NodeId rootNodeId)
{
    m_rootNodeId = rootNodeId;
}

//
//  Returns true if the given node can be collapsed to its parent

HK_INLINE bool hkcdPlanarSolid::canCollapse(NodeId nodeId) const
{
    if ( !nodeId.isValid() ) return false;
    const Node& node        = getNode(nodeId);
    const Node& nodeLeft    = getNode(node.m_left);
    const Node& nodeRight   = getNode(node.m_right);
    return  (nodeLeft.m_type == nodeRight.m_type) &&
            ((nodeLeft.m_type == hkcdPlanarSolid::NODE_TYPE_IN) || (nodeLeft.m_type == hkcdPlanarSolid::NODE_TYPE_OUT));
}

//
//  Returns true if the triangle is allocated

HK_INLINE bool hkcdPlanarSolid::Node::isAllocated() const
{
    return m_type != NODE_TYPE_FREE;
}

//
//  Marks this node as not-allocated

HK_INLINE void hkcdPlanarSolid::Node::clear()
{
    m_type = NODE_TYPE_FREE;
}

//
//  Called by the free-list to initialize an unallocated entry

HK_INLINE void hkcdPlanarSolid::Node::setEmpty(Node& element, hkUint32 next)
{
    (hkUint32&)element = next;  element.clear();
}

//
//  Returns the index of the next free element. Will be called only with empty elements

HK_INLINE hkUint32 hkcdPlanarSolid::Node::getNext(const Node& element)
{
    return (hkUint32&)element;
}

//
//  Sets the given child id

HK_INLINE void hkcdPlanarSolid::Node::setChildId(int childIdx, NodeId childNodeId)
{
    (&m_left)[childIdx] = childNodeId;
}

//
//  Classifies the polygons into inside, boundary, and outside parts

HK_INLINE hkResult hkcdPlanarSolid::classifyPolygons(   hkcdPlanarGeometry& polySoup, const hkArray<PolygonId>& polygonsIn,
                                                        hkArray<PolygonId>& insidePieces, hkArray<PolygonId>& boundaryPieces, hkArray<PolygonId>& outsidePieces, _Inout_opt_ ArrayMgr* arrayMgr) const
{
    if ( arrayMgr == HK_NULL )
    {
        ArrayMgr localArrayMgr;
        return classifyPolygons(polySoup, getRootNodeId(), polygonsIn, insidePieces, boundaryPieces, outsidePieces, localArrayMgr);
    }
    return classifyPolygons(polySoup, getRootNodeId(), polygonsIn, insidePieces, boundaryPieces, outsidePieces, *arrayMgr);
}

//
//  Constructor

HK_INLINE hkcdPlanarSolid::ArrayMgr::ArrayMgr()
{
    clear();
}

//
//  Allocates an array slot. The storage for the array is not yet allocated

HK_INLINE hkcdPlanarSolid::ArrayId hkcdPlanarSolid::ArrayMgr::allocArraySlot()
{
    const ArrayId aid   = m_arrays.allocate();
    ArraySlot& slot     = m_arrays[aid];
    slot.m_offset   = 0;
    slot.m_size     = 0;

    return aid;
}

//
// Returns the array slot at the given Id

HK_INLINE hkcdPlanarSolid::ArraySlot& hkcdPlanarSolid::ArrayMgr::getArraySlot(ArrayId aid)
{
    return m_arrays[aid];
}

//
// Returns the array storage for the given Id

HK_INLINE hkcdPlanarSolid::PolygonId hkcdPlanarSolid::ArrayMgr::getPolygonId(ArrayId aid, int k)
{
    return PolygonId(m_storage[getArraySlot(aid).m_offset + k] & PAYLOAD_MASK);
}

//
//  Allocates storage for numPolygons in the array at the given slot

HK_INLINE hkResult hkcdPlanarSolid::ArrayMgr::allocArrayStorage(ArrayId arraySlot, _In_reads_(numPolygons) const PolygonId* HK_RESTRICT srcPolyIds, int numPolygons)
{
    // Allocate polygons
    ArraySlot& arrayElement = m_arrays[arraySlot];
    hkUint32 allocSize      = hkMath::max2<hkUint32>(MIN_BLOCK_SIZE, numPolygons);
    hkUint32 blockAllocResult = blockAlloc(allocSize);
    if( blockAllocResult == INVALID_BLOCK_ADDR )
    {
        return HK_FAILURE;
    }
    arrayElement.m_offset = blockAllocResult;
    arrayElement.m_size     = numPolygons;

    // Copy
    int* ptr = &m_storage[arrayElement.m_offset];
    for (int k = numPolygons - 1; k >= 0; k--)
    {
        ptr[k] = (ptr[k] & BLOCK_FLAGS_MASK) | (srcPolyIds[k].value() & PAYLOAD_MASK);
    }
    ptr[numPolygons - 1] |= END_PAYLOAD_FLAG;
    return HK_SUCCESS;
}

HK_INLINE hkResult hkcdPlanarSolid::ArrayMgr::allocArrayStorage(ArrayId arraySlot, const hkArray<PolygonId>& srcPolyIds)
{
    HK_ASSERT_NO_MSG(0x2bc0d8cd, srcPolyIds.getSize());
    return allocArrayStorage(arraySlot, srcPolyIds.begin(), srcPolyIds.getSize());
}

HK_INLINE void hkcdPlanarSolid::ArrayMgr::freeArray(ArrayId arraySlot)
{
    ArraySlot& arrayElement = m_arrays[arraySlot];
    if ( arrayElement.m_offset )
    {
        blockFree(arrayElement.m_offset, arrayElement.m_size);
    }
    m_arrays.release(arraySlot);
}

//
//  Resets the manager for a new use

HK_INLINE void hkcdPlanarSolid::ArrayMgr::reset()
{
    clear();
    m_arrays.clear();
}

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
