// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_HAVOK_ASSEMBLY_EXCLUDE_FILE

#pragma once

#include <Geometry/Collide/DataStructures/Planar/Memory/hkcdPlanarGeometryPrimitivesCollection.h>
#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>

namespace hkcdPlanarGeometryPrimitives
{
    /// Low-level memory management for a collection of primitives
    template <class Coll>
    class CollectionManager : public hkReferencedObject
    {
        public:
            HK_DECLARE_CLASS(CollectionManager, New);

            /// Constants
            enum
            {
                MANAGER_DEFAULT_MAX_SIZE = 200,
            };

            /// Constructor
            CollectionManager();

            /// Returns a unused collection (a new one will be allocated if no one is free)
            void getUnusedCollection(hkRefPtr<Coll>& collection);

            /// Expands the number of free collection by the specified amount (clamped to the maximum size).
            void expandCollectionPoolBy(int num, hkUint32 allocSize);

            /// Sets the maximum size allowed for the collection pool
            HK_INLINE void setMaxSize(int maxSize);

        public:

            int m_maxSize;                                  ///< Maximum size of the collection pool
            int m_lastReturnedCollectionId;                 ///< Index in the collection array of the last return collection id
            hkArray< hkRefPtr<Coll> > m_collectionsArray;   ///< Static preallocated collections
            hkCriticalSection m_criticalSection;            ///< For safe multithread access
    };
}

#include <Geometry/Collide/DataStructures/Planar/Memory/hkcdPlanarGeometryPrimitivesCollectionManager.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
