// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

//
//  Constructor

HK_INLINE hkcdPlanarGeometryPolygonCollection::TriangleProviderId::TriangleProviderId(int i)
:   m_val(i & INVALID_VALUE)
{}

//
//  Returns an invalid triangle source

HK_INLINE hkcdPlanarGeometryPolygonCollection::TriangleProviderId HK_CALL hkcdPlanarGeometryPolygonCollection::TriangleProviderId::invalid()
{
    return TriangleProviderId(INVALID_VALUE);
}

//
//  One liners

HK_INLINE bool hkcdPlanarGeometryPolygonCollection::TriangleProviderId::isValid()                                   const   {   return (m_val & INVALID_VALUE) != INVALID_VALUE;    }
HK_INLINE hkUint32 hkcdPlanarGeometryPolygonCollection::TriangleProviderId::value()                                 const   {   return m_val;                   }
HK_INLINE bool hkcdPlanarGeometryPolygonCollection::TriangleProviderId::operator<(const TriangleProviderId& other)  const   {   return m_val < other.m_val;     }
HK_INLINE bool hkcdPlanarGeometryPolygonCollection::TriangleProviderId::operator==(const TriangleProviderId& other) const   {   return m_val == other.m_val;    }
HK_INLINE bool hkcdPlanarGeometryPolygonCollection::TriangleProviderId::operator!=(const TriangleProviderId& other) const   {   return m_val != other.m_val;    }

//
//  Constructor

HK_INLINE hkcdPlanarGeometryPolygonCollection::Material::Material()
:   m_val(0)
{
    setTriangleProviderId(TriangleProviderId::invalid());
}

//
//  Return the min value for invalid material

HK_INLINE hkcdPlanarGeometryPolygonCollection::Material HK_CALL hkcdPlanarGeometryPolygonCollection::Material::invalid()
{
    return Material();
}

//
//  Returns the triangle index

HK_INLINE hkUint32 hkcdPlanarGeometryPolygonCollection::Material::getTriangleIndex() const
{
    const hkUint64 mask = (hkUint64(1) << hkUint64(NUM_BITS_TRIANGLE_INDEX)) - hkUint64(1);
    const hkUint64 idx  = hkUint64(m_val) >> hkUint64(OFFSET_TRIANGLE_INDEX);

    return int(idx & mask);
}

//
//  Sets the triangle index

HK_INLINE void hkcdPlanarGeometryPolygonCollection::Material::setTriangleIndex(int idx)
{
    const hkUint64 mask     = ((hkUint64(1) << hkUint64(NUM_BITS_TRIANGLE_INDEX)) - hkUint64(1)) << hkUint64(OFFSET_TRIANGLE_INDEX);
    const hkUint64 newVal   = hkUint64(idx) << hkUint64(OFFSET_TRIANGLE_INDEX);

    m_val = (m_val & (~mask)) | (newVal & mask);
}

//
//  Returns the Id of the triangle source

HK_INLINE hkcdPlanarGeometryPolygonCollection::TriangleProviderId hkcdPlanarGeometryPolygonCollection::Material::getTriangleProviderId() const
{
    const hkUint64 tsMask       = (hkUint64(1) << hkUint64(NUM_BITS_TRIANGLE_SOURCE_ID)) - hkUint64(1);
    const hkUint64 triSource    = hkUint64(m_val) >> hkUint64(OFFSET_TRIANGLE_SOURCE_ID);

    return TriangleProviderId(int(triSource & tsMask));
}

//
//  Sets the Id of the triangle source

HK_INLINE void hkcdPlanarGeometryPolygonCollection::Material::setTriangleProviderId(TriangleProviderId tsId)
{
    const hkUint64 mask     = ((hkUint64(1) << hkUint64(NUM_BITS_TRIANGLE_SOURCE_ID)) - hkUint64(1)) << hkUint64(OFFSET_TRIANGLE_SOURCE_ID);
    const hkUint64 newVal   = hkUint64(tsId.m_val) << hkUint64(OFFSET_TRIANGLE_SOURCE_ID);

    m_val = (m_val & (~mask)) | (newVal & mask);
}

//
//  Gets / sets the flags

HK_INLINE hkUint8 hkcdPlanarGeometryPolygonCollection::Material::getFlags() const
{
    const hkUint64 mask     = (hkUint64(1) << hkUint64(NUM_BITS_FLAGS)) - hkUint64(1);
    const hkUint64 flags    = hkUint64(m_val) >> hkUint64(OFFSET_FLAGS);

    return int(flags & mask);
}

HK_INLINE void hkcdPlanarGeometryPolygonCollection::Material::setFlags(hkUint8 flags)
{
    const hkUint64 mask     = ((hkUint64(1) << hkUint64(NUM_BITS_FLAGS)) - hkUint64(1)) << hkUint64(OFFSET_FLAGS);
    const hkUint64 newVal   = hkUint64(flags) << hkUint64(OFFSET_FLAGS);

    m_val = (m_val & (~mask)) | (newVal & mask);
}

//
//  One-liners

HK_INLINE bool hkcdPlanarGeometryPolygonCollection::Material::isValid()                         const   {   return getTriangleProviderId().isValid();   }
HK_INLINE hkUint64 hkcdPlanarGeometryPolygonCollection::Material::value()                       const   {   return m_val;   }
HK_INLINE bool hkcdPlanarGeometryPolygonCollection::Material::operator==(const Material& other) const   {   return m_val == other.m_val;    }
HK_INLINE bool hkcdPlanarGeometryPolygonCollection::Material::operator!=(const Material& other) const   {   return m_val != other.m_val;    }

//
//  Returns the material id

HK_INLINE hkcdPlanarGeometryPolygonCollection::Material hkcdPlanarGeometryPolygonCollection::Polygon::getMaterial() const
{
    Material ret;
    hkUint32 hi = m_triSourceId & PAYLOAD_MASK;
    hkUint32 lo = m_triId & PAYLOAD_MASK;

    ret.m_val = (hkUint64(hi) << hkUint64(32)) | hkUint64(lo);

    return ret;
}

HK_INLINE void hkcdPlanarGeometryPolygonCollection::Polygon::setMaterial(const Material& materialIn)
{
    const hkUint64 matId    = materialIn.value();
    const hkUint32 hi       = hkUint32(matId >> hkUint64(32));
    const hkUint32 lo       = hkUint32(matId & 0xFFFFFFFF);

    HK_ASSERT_NO_MSG(0x1cf0dcaf, !(hi & BLOCK_FLAGS_MASK));
    HK_ASSERT_NO_MSG(0x1cf0dcb1, !(lo & BLOCK_FLAGS_MASK));
    m_triSourceId   = (hi & PAYLOAD_MASK) | (m_triSourceId & BLOCK_FLAGS_MASK);
    m_triId         = (lo & PAYLOAD_MASK) | (m_triId & BLOCK_FLAGS_MASK);
}

//
//  Returns the support plane id

HK_INLINE hkcdPlanarGeometryPolygonCollection::PlaneId hkcdPlanarGeometryPolygonCollection::Polygon::getSupportPlaneId() const
{
    return PlaneId(m_supportId & PAYLOAD_MASK);
}

HK_INLINE void hkcdPlanarGeometryPolygonCollection::Polygon::setSupportPlaneId(PlaneId pid)
{
    m_supportId = (m_supportId & BLOCK_FLAGS_MASK) | (pid.valueUnchecked() & PAYLOAD_MASK);
}

//
//  Returns the i-th boundary plane Id

HK_INLINE hkcdPlanarGeometryPolygonCollection::PlaneId hkcdPlanarGeometryPolygonCollection::Polygon::getBoundaryPlaneId(int i) const
{
    return PlaneId((&m_supportId)[1 + (i << 1)] & PAYLOAD_MASK);
}

HK_INLINE void hkcdPlanarGeometryPolygonCollection::Polygon::setBoundaryPlaneId(int i, PlaneId pid)
{
    hkUint32& p = (&m_supportId)[1 + (i << 1)];
    p = (p & BLOCK_FLAGS_MASK) | (pid.valueUnchecked() & PAYLOAD_MASK);
}

//
// Returns the i-th vertex

HK_INLINE hkcdPlanarGeometryPolygonCollection::VertexId hkcdPlanarGeometryPolygonCollection::Polygon::getVertexId(int i) const
{
    return VertexId((&m_supportId)[2 + (i << 1)] & PAYLOAD_MASK);
}

HK_INLINE void hkcdPlanarGeometryPolygonCollection::Polygon::setVertexId(int i, VertexId vid)
{
    hkUint32& v = (&m_supportId)[2 + (i << 1)];
    v = (v & BLOCK_FLAGS_MASK) | (vid.valueUnchecked() & PAYLOAD_MASK);
}

//
//  Retrieves the polygon at the given Id.

HK_INLINE const hkcdPlanarGeometryPolygonCollection::Polygon& hkcdPlanarGeometryPolygonCollection::getPolygon(PolygonId polyId) const
{
    return *reinterpret_cast<const Polygon*>(&m_storage[polyId.value()]);
}

HK_INLINE hkcdPlanarGeometryPolygonCollection::Polygon& hkcdPlanarGeometryPolygonCollection::accessPolygon(PolygonId polyId)
{
    return *reinterpret_cast<Polygon*>(&m_storage[polyId.value()]);
}

//
//  Allocates a polygon

HK_INLINE hkcdPlanarGeometryPolygonCollection::PolygonId hkcdPlanarGeometryPolygonCollection::alloc(PlaneId supportPlaneId, const Material& materialIn, int numBoundaryPlanes)
{
    // Allocate polygon storage
    const int numDataElem   = numBoundaryPlanes << 1;
    hkUint32 allocSize      = hkMath::max2<hkUint32>(MIN_BLOCK_SIZE, (sizeof(Polygon) / sizeof(int)) + numDataElem);
    const PolygonId polyId(blockAlloc(allocSize));
    if ( !polyId.isValid() )
    {
        return PolygonId::invalid();
    }

    // Set it up
    Polygon& poly = accessPolygon(polyId);
    poly.setMaterial(materialIn);
    poly.setSupportPlaneId(supportPlaneId);

    // Get planes and mark the last one
    hkUint32* planes = reinterpret_cast<hkUint32*>(&poly.m_supportId);
    planes[numDataElem] |= END_PAYLOAD_FLAG;

    // Sanity checks
#ifdef HK_DEBUG
    {
        // There should be just one plane marked as the end plane
        for (int k = 0; k < numDataElem; k++)
        {
            HK_ASSERT_NO_MSG(0x5e96e8a3, !(planes[k] & END_PAYLOAD_FLAG));
        }

        // There should be and end block marker
        HK_ASSERT_NO_MSG(0x27fb4c, planes[allocSize - Polygon::BOUNDARY_PLANES_OFFSET] & END_BLOCK_FLAG);

        // There should be no other end block marker
        for (hkUint32 k = 0; k < allocSize - Polygon::BOUNDARY_PLANES_OFFSET; k++)
        {
            HK_ASSERT_NO_MSG(0x20fa5bdb, !(planes[k] & END_BLOCK_FLAG));
        }
    }
#endif

    return polyId;
}

//
//  Frees the given polygon

HK_INLINE void hkcdPlanarGeometryPolygonCollection::freePolygon(PolygonId polyId)
{
    blockFree(polyId.value());
}

//
//  Computes the number of boundary planes

HK_INLINE int hkcdPlanarGeometryPolygonCollection::getNumBoundaryPlanes(PolygonId polyId) const
{
    const int* planes = &m_storage[polyId.value() + Polygon::SUPPORT_PLANE_ID_OFFSET];

    int count = 0;
    while ( !(planes[count] & END_PAYLOAD_FLAG) )
    {
        count += 2;
    }
    return (count >> 1);
}

//
//  Returns the first valid polygon Id

HK_INLINE hkcdPlanarGeometryPolygonCollection::PolygonId hkcdPlanarGeometryPolygonCollection::getFirstPolygonId() const
{
    return getNextPolygonId(PolygonId(hkUint32(INVALID_BLOCK_ADDR)));
}

//
//  Returns the last valid polygon Id

HK_INLINE hkcdPlanarGeometryPolygonCollection::PolygonId hkcdPlanarGeometryPolygonCollection::getLastPolygonId() const
{
    return getPrevPolygonId(PolygonId(m_storage.getSize() - MIN_BLOCK_SIZE));
}

//
//  Returns the next valid polygon Id

HK_INLINE hkcdPlanarGeometryPolygonCollection::PolygonId hkcdPlanarGeometryPolygonCollection::getNextPolygonId(PolygonId polyId) const
{
    return PolygonId(getNextAllocatedAddress(polyId.valueUnchecked()));
}

//
//  Returns the next valid polygon Id

HK_INLINE hkcdPlanarGeometryPolygonCollection::PolygonId hkcdPlanarGeometryPolygonCollection::getPrevPolygonId(PolygonId polyId) const
{
    return PolygonId(getPrevAllocatedAddress(polyId.valueUnchecked()));
}

//
//  Returns the number of valid polygon Ids stored

HK_INLINE int hkcdPlanarGeometryPolygonCollection::getNumPolygons() const
{
    int count = 0;
    for (PolygonId pid = getFirstPolygonId(); pid.isValid(); pid = getNextPolygonId(pid))
    {
        count++;
    }
    return count;
}

//
//  Reverses the boundary winding

HK_INLINE void hkcdPlanarGeometryPolygonCollection::flipWinding(PolygonId polyId)
{
    const int n     = getNumBoundaryPlanes(polyId) - 1;
    Polygon& poly   = accessPolygon(polyId);
    for (int i = 0; (i << 1) < n; i++)
    {
        // swap plane ids
        const PlaneId boundI    = poly.getBoundaryPlaneId(i);
        const PlaneId boundNI   = poly.getBoundaryPlaneId(n - i);
        poly.setBoundaryPlaneId(i, boundNI);
        poly.setBoundaryPlaneId(n - i, boundI);

        // swap vertex ids
        const VertexId vI       = poly.getVertexId(i);
        const VertexId vNI      = poly.getVertexId(n - i);
        poly.setVertexId(i, vI);
        poly.setVertexId(n - i, vNI);
    }

    poly.setSupportPlaneId(hkcdPlanarGeometryPrimitives::getOppositePlaneId(poly.getSupportPlaneId()));
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
