// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_HAVOK_ASSEMBLY_EXCLUDE_FILE

#pragma once

#include <Geometry/Collide/DataStructures/Planar/Primitives/hkcdPlanarGeometryPrimitives.h>
#include <Geometry/Collide/DataStructures/Planar/Memory/hkcdPlanarGeometryPrimitivesCollection.h>

/// A collection of polygons.
class HK_EXPORT_COMMON hkcdPlanarGeometryPolygonCollection : public hkcdPlanarGeometryPrimitives::Collection<hkcdPlanarGeometryPrimitives::FLIPPED_PLANE_BIT>
{
    public:

        HK_DECLARE_CLASS(hkcdPlanarGeometryPolygonCollection, New, Reflect, BypassCtor);

        // Types
        HK_DECLARE_HANDLE(PolygonId, hkUint32, INVALID_BLOCK_ADDR);
        HK_DECLARE_HANDLE(VertexId, hkUint32, PAYLOAD_MASK);
        typedef hkcdPlanarGeometryPrimitives::PlaneId PlaneId;

    public:

        struct Material;
        struct Polygon;

        /// The Id of a triangle provider. The payload size is stored on 23 bits.
        struct HK_EXPORT_COMMON TriangleProviderId
        {
            public:

                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY, hkcdPlanarGeometryPolygonCollection::TriangleProviderId);

                friend struct Material;

                enum
                {
                    NUM_BITS        = 23,
                    INVALID_VALUE   = (1 << NUM_BITS) - 1,
                };

                /// Constructor
                HK_INLINE TriangleProviderId(int i = INVALID_VALUE);

                /// Returns an invalid triangle source
                static HK_INLINE TriangleProviderId HK_CALL invalid();

                /// Returns true if the triangle source is valid
                HK_INLINE bool isValid() const;

                /// Returns the value
                HK_INLINE hkUint32 value() const;

                /// Comparators
                HK_INLINE bool operator<(const TriangleProviderId& other) const;
                HK_INLINE bool operator==(const TriangleProviderId& other) const;
                HK_INLINE bool operator!=(const TriangleProviderId& other) const;

            protected:

                hkUint32 m_val;
        };

        /// A material
        HK_CLASSALIGN8(struct) HK_EXPORT_COMMON Material
        {
            public:

                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY, hkcdPlanarGeometryPolygonCollection::Material);
                HK_DECLARE_REFLECTION();

                friend struct Polygon;

            public:

                enum
                {
                    NUM_BITS_TRIANGLE_INDEX     = 32,
                    NUM_BITS_TRIANGLE_SOURCE_ID = TriangleProviderId::NUM_BITS,
                    NUM_BITS_FLAGS              = 1,

                    OFFSET_TRIANGLE_INDEX       = 0,
                    OFFSET_TRIANGLE_SOURCE_ID   = OFFSET_TRIANGLE_INDEX + NUM_BITS_TRIANGLE_INDEX,
                    OFFSET_FLAGS                = OFFSET_TRIANGLE_SOURCE_ID + NUM_BITS_TRIANGLE_SOURCE_ID,
                    OFFSET_RESERVED             = OFFSET_FLAGS + NUM_BITS_FLAGS,
                    NUM_BITS_RESERVED           = 64 - OFFSET_RESERVED,
                };

                // Flags
                enum FlagValues
                {
                    IS_FLIPPED  = (1 << 0),
                };

                /// Constructor
                HK_INLINE Material();

                /// Gets / sets the triangle index
                HK_INLINE hkUint32 getTriangleIndex() const;
                HK_INLINE void setTriangleIndex(int idx);

                /// Gets / sets the Id of the triangle provider
                HK_INLINE TriangleProviderId getTriangleProviderId() const;
                HK_INLINE void setTriangleProviderId(TriangleProviderId tsId);

                // Gets / sets the flags
                HK_INLINE hkUint8 getFlags() const;
                HK_INLINE void setFlags(hkUint8 flags);

                /// Returns an invalid material
                static HK_INLINE Material invalid();

                /// Returns true if the material is valid
                HK_INLINE bool isValid() const;

                /// Advanced use! Returns the value.
                HK_INLINE hkUint64 value() const;

                /// Comparators
                HK_INLINE bool operator==(const Material& other) const;
                HK_INLINE bool operator!=(const Material& other) const;

            protected:

                hkUint64 m_val;
        };

        /// A polygon, defined by a support plane and a CCW set of bounding planes along its edges.
        struct Polygon
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY, hkcdPlanarGeometryPolygonCollection::Polygon);

            friend class hkcdPlanarGeometryPolygonCollection;

            enum
            {
                SUPPORT_PLANE_ID_OFFSET = 2,
                BOUNDARY_PLANES_OFFSET  = 3,
            };

            public:

                /// Returns the material
                HK_INLINE Material getMaterial() const;
                HK_INLINE void setMaterial(const Material& materialIn);

                /// Returns the support plane Id
                HK_INLINE PlaneId getSupportPlaneId() const;
                HK_INLINE void setSupportPlaneId(PlaneId pid);

                /// Gets / sets the i-th boundary plane Id
                HK_INLINE PlaneId getBoundaryPlaneId(int i) const;
                HK_INLINE void setBoundaryPlaneId(int i, PlaneId pid);

                /// Gets / sets the i-th vertex id
                HK_INLINE VertexId getVertexId(int i) const;
                HK_INLINE void setVertexId(int i, VertexId vid);

            protected:

                hkUint32 m_triSourceId;
                hkUint32 m_triId;
                hkUint32 m_supportId;
        };

    public:

        /// Constructor
        hkcdPlanarGeometryPolygonCollection();

        /// Copy constructor
        hkcdPlanarGeometryPolygonCollection(const hkcdPlanarGeometryPolygonCollection& other);

        /// Compacts the storage
        void compactStorage();

    public:

        /// Retrieves the polygon at the given Id.
        HK_INLINE const Polygon& getPolygon(PolygonId polyId) const;
        HK_INLINE Polygon& accessPolygon(PolygonId polyId);

        /// Computes the number of boundary planes
        HK_INLINE int getNumBoundaryPlanes(PolygonId polyId) const;

        /// Reverses the boundary winding
        HK_INLINE void flipWinding(PolygonId polyId);

        // Allocates a polygon having the given number of boundary planes
        HK_INLINE PolygonId alloc(PlaneId supportPlaneId, const Material& materialIn, int numBoundaryPlanes);

        /// Frees the given polygon
        HK_INLINE void freePolygon(PolygonId polyId);

        /// Returns the first valid polygon Id
        HK_INLINE PolygonId getFirstPolygonId() const;

        /// Returns the last valid polygon Id
        HK_INLINE PolygonId getLastPolygonId() const;

        /// Returns the next valid polygon Id
        HK_INLINE PolygonId getNextPolygonId(PolygonId polyId) const;

        /// Returns the previous valid polygon Id
        HK_INLINE PolygonId getPrevPolygonId(PolygonId polyId) const;

        /// Returns the number of valid polygon Ids stored
        HK_INLINE int getNumPolygons() const;
};

#include <Geometry/Collide/DataStructures/Planar/Memory/hkcdPlanarGeometryPolygonCollection.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
