// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

//
//  Returns true if the cell is a leaf

HK_INLINE bool hkcdNewCellsCollection::Cell::isLeaf() const
{
    return (m_flags & CELL_LEAF_MASK);
}

//
//  Returns true if the cell is empty / solid / unknown

HK_INLINE int hkcdNewCellsCollection::Cell::isEmpty() const {   return (m_flags & CELL_EMPTY_MASK); }
HK_INLINE int hkcdNewCellsCollection::Cell::isSolid() const {   return (m_flags & CELL_SOLID_MASK); }
HK_INLINE int hkcdNewCellsCollection::Cell::isUnknown() const   {   return !(isEmpty() || isSolid());           }
HK_INLINE int hkcdNewCellsCollection::Cell::isVisited() const   {   return ( m_flags & CELL_VISITED_MASK );}

//
//  Sets the cell as empty / solid

HK_INLINE void hkcdNewCellsCollection::Cell::setEmpty()             {   m_flags &= ~CELL_SOLID_MASK;    m_flags |= CELL_EMPTY_MASK; }
HK_INLINE void hkcdNewCellsCollection::Cell::setSolid()             {   m_flags &= ~CELL_EMPTY_MASK;    m_flags |= CELL_SOLID_MASK; }
HK_INLINE void hkcdNewCellsCollection::Cell::setVisited(bool visited)   {   if ( visited )  m_flags = m_flags | CELL_VISITED_MASK;  else m_flags = m_flags & (~CELL_VISITED_MASK); }
HK_INLINE void hkcdNewCellsCollection::Cell::setLeaf(bool leaf)     {   if ( leaf )     m_flags = m_flags | CELL_LEAF_MASK;     else m_flags = m_flags & (~CELL_LEAF_MASK); }

//
//  Returns the cell label

HK_INLINE hkcdNewCellsCollection::Labels hkcdNewCellsCollection::Cell::getLabel() const
{
    return isEmpty() ? CELL_EMPTY : (isSolid() ? CELL_SOLID : CELL_UNKNOWN);
}

HK_INLINE void hkcdNewCellsCollection::Cell::setLabel(Labels l)
{
    HK_ASSERT_NO_MSG(0x11e814a9, (l == CELL_SOLID) || (l == CELL_EMPTY));
    if ( l == CELL_SOLID )  {   setSolid(); }
    else                    {   setEmpty(); }
}

//
//  Gets / Sets user data

HK_INLINE hkUint32 hkcdNewCellsCollection::Cell::getUserData() const
{
    return m_userData;
}

HK_INLINE void hkcdNewCellsCollection::Cell::setUserData(hkUint32 data)
{
    m_userData = data;
}

//
//  Data pointer access

HK_INLINE _Ret_notnull_ hkcdNewCellsCollection::VertexId* hkcdNewCellsCollection::Cell::accessVertexIdsPointer()
{
    return m_vertices.begin();
}

HK_INLINE _Ret_notnull_ hkcdNewCellsCollection::EdgeId* hkcdNewCellsCollection::Cell::accessEdgeIdsPointer()
{
    return m_edges.begin();
}

HK_INLINE _Ret_notnull_ hkcdNewCellsCollection::FaceId* hkcdNewCellsCollection::Cell::accessFaceIdsPointer()
{
    return m_faces.begin();
}

HK_INLINE _Ret_notnull_ const hkcdNewCellsCollection::VertexId* hkcdNewCellsCollection::Cell::getVertexIdsPointer() const
{
    return m_vertices.begin();
}

HK_INLINE _Ret_notnull_ const hkcdNewCellsCollection::EdgeId* hkcdNewCellsCollection::Cell::getEdgeIdsPointer() const
{
    return m_edges.begin();
}

HK_INLINE _Ret_notnull_ const hkcdNewCellsCollection::FaceId* hkcdNewCellsCollection::Cell::getFaceIdsPointer() const
{
    return m_faces.begin();
}

//
//  Data value access

HK_INLINE hkcdNewCellsCollection::FaceId hkcdNewCellsCollection::Cell::getFaceId(int i) const
{
    return getFaceIdsPointer()[i];
}

HK_INLINE hkcdNewCellsCollection::VertexId hkcdNewCellsCollection::Cell::getVertexId(int i) const
{
    return getVertexIdsPointer()[i];
}

HK_INLINE hkcdNewCellsCollection::EdgeId hkcdNewCellsCollection::Cell::getEdgeId(int i) const
{
    return getEdgeIdsPointer()[i];
}

HK_INLINE hkUint32 hkcdNewCellsCollection::Cell::getNumFaces() const
{
    return m_faces.getSize();
}

HK_INLINE hkUint32 hkcdNewCellsCollection::Cell::getNumVertices() const
{
    return m_vertices.getSize();
}

HK_INLINE hkUint32 hkcdNewCellsCollection::Cell::getNumEdges() const
{
    return m_edges.getSize();
}

//
//  Change data size (dynamic cells only)

HK_INLINE void hkcdNewCellsCollection::Cell::setNumFaces(hkUint32 size)
{
    m_faces.setSize(size);
}

HK_INLINE void hkcdNewCellsCollection::Cell::setNumVertices(hkUint32 size)
{
    m_vertices.setSize(size);
}

HK_INLINE void hkcdNewCellsCollection::Cell::setNumEdges(hkUint32 size)
{
    m_edges.setSize(size);
}

HK_INLINE void hkcdNewCellsCollection::Cell::setSizes(hkUint32 numFaces, hkUint32 numVertices, hkUint32 numEdges)
{
    setNumFaces(numFaces);
    setNumVertices(numVertices);
    setNumEdges(numEdges);
}

//
//  Copy data from another cell

HK_INLINE void hkcdNewCellsCollection::Cell::copy(const Cell& other)
{
    m_edges.append(other.m_edges);
    m_vertices.append(other.m_vertices);
    m_faces.append(other.m_faces);
    m_prevCellId    = other.m_prevCellId;
    m_nextCellId    = other.m_nextCellId;
    m_flags         = other.m_flags;
    m_userData      = other.m_userData;
}

//
//  Retrieves the cell at the given Id.

HK_INLINE const hkcdNewCellsCollection::Cell& hkcdNewCellsCollection::getCell(CellId cellId) const
{
    return m_cells[cellId.value()];
}

HK_INLINE hkcdNewCellsCollection::Cell& hkcdNewCellsCollection::accessCell(CellId cellId)
{
    return m_cells[cellId.value()];
}

HK_INLINE hkcdNewCellsCollection::CellId hkcdNewCellsCollection::getFirstCellId() const
{
    return m_firstCellId;
}

//
//  Returns the last valid cell Id

HK_INLINE hkcdNewCellsCollection::CellId hkcdNewCellsCollection::getLastCellId() const
{
    return m_lastCellId;
}

//
//  Returns the next valid cell Id

HK_INLINE hkcdNewCellsCollection::CellId hkcdNewCellsCollection::getNextCellId(CellId cellId) const
{
    return getCell(cellId).m_nextCellId;
}

//
//  Returns the next valid cell Id

HK_INLINE hkcdNewCellsCollection::CellId hkcdNewCellsCollection::getPrevCellId(CellId cellId) const
{
    return getCell(cellId).m_prevCellId;
}

//
//  Allocates a cell

HK_INLINE hkcdNewCellsCollection::CellId hkcdNewCellsCollection::allocCell()
{
    int newCellId;

    // Get a new cell either from the deleted cell cache, or allocate a new one
    if ( m_freeCells.getSize() )
    {
        newCellId = m_freeCells[0];
        m_freeCells.removeAt(0);
    }
    else
    {
        newCellId = m_cells.getSize();
        m_cells.expandOne();
    }

    // Set the new cell default values
    Cell& newCell = m_cells[newCellId];
    newCell.m_flags             = 0;
    newCell.m_userData          = 0;
    newCell.m_prevCellId        = m_lastCellId;
    newCell.m_nextCellId        = CellId::invalid();
    newCell.setSizes(0, 0, 0);

    // Update first and last cell ids
    m_lastCellId = CellId(newCellId);
    if ( !m_firstCellId.isValid() )
    {
        m_firstCellId = m_lastCellId;
    }
    if ( newCell.m_prevCellId.isValid() )
    {
        accessCell(newCell.m_prevCellId).m_nextCellId = m_lastCellId;
    }

    return m_lastCellId;
}

//
//  Frees the given cell

HK_INLINE void hkcdNewCellsCollection::freeCell(CellId cellId)
{
    m_freeCells.pushBack(cellId.value());

    // Update cell chain
    const Cell& cell = getCell(cellId);
    if ( cell.m_prevCellId.isValid() )
    {
        accessCell(cell.m_prevCellId).m_nextCellId = cell.m_nextCellId;
    }
    else
    {
        m_firstCellId = cell.m_nextCellId;
    }
    if (cell.m_nextCellId.isValid())
    {
        accessCell(cell.m_nextCellId).m_prevCellId = cell.m_prevCellId;
    }
    else
    {
        m_lastCellId = cell.m_prevCellId;
    }
}

//
//  Copy data

HK_INLINE void hkcdNewCellsCollection::copy(const hkcdNewCellsCollection& other)
{
    m_cells.setSize(other.m_cells.getSize());
    for (int c = 0, nc = m_cells.getSize() ; c < nc ; c++)
    {
        const Cell& srcCell = other.getCell(CellId(c));
        Cell& dstCell       = accessCell(CellId(c));
        dstCell.copy(srcCell);
    }
    m_firstCellId = other.m_firstCellId;
    m_lastCellId = other.m_lastCellId;
    m_freeCells.append(other.m_freeCells);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
