// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Geometry/Collide/DataStructures/Planar/Primitives/hkcdPlanarGeometryPrimitives.h>
//#include <Geometry/Collide/DataStructures/Planar/Memory/hkcdPlanarGeometryPrimitivesCollection.h>

#define HKND_NEW_CELLS_DYNAMIC_CELLS

/// A collection of convex cells.
class HK_EXPORT_COMMON hkcdNewCellsCollection : public hkReferencedObject //: public hkcdPlanarGeometryPrimitives::Collection<hkcdPlanarGeometryPrimitives::FLIPPED_PLANE_BIT>
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY);

        // Types
        //HK_DECLARE_HANDLE(CellId, hkUint32, INVALID_BLOCK_ADDR);
        HK_DECLARE_HANDLE(CellId, hkUint32, hkUint32(-1));
        typedef hkcdPlanarGeometryPrimitives::PlaneId           PlaneId;
        typedef hkUint32                                        VertexId;
        typedef hkUint32                                        EdgeId;
        typedef hkUint32                                        FaceId;

    public:

        /// Cell labels
        enum Labels
        {
            CELL_UNKNOWN        = 0,    ///< Unknown / unlabeled
            CELL_EMPTY          = 1,    ///< Empty space
            CELL_SOLID          = 2,    ///< Solid space
        };

        /// Constants
        enum
        {
            CELL_EMPTY_BIT      = 0,
            CELL_SOLID_BIT      = 1,
            CELL_LEAF_BIT       = 2,
            CELL_VISITED_BIT    = 3,
            CELL_EMPTY_MASK     = (1 << CELL_EMPTY_BIT),
            CELL_SOLID_MASK     = (1 << CELL_SOLID_BIT),
            CELL_LEAF_MASK      = (1 << CELL_LEAF_BIT),
            CELL_VISITED_MASK   = (1 << CELL_VISITED_BIT),
        };

    public:


        /// A convex cell, as a collection of 2D convex polygons
        struct Cell
        {
            friend class hkcdNewCellsCollection;

        public:
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY, hkcdNewCellsCollection::Cell);

        public:

            /// Copy data from another cell
            HK_INLINE void copy(const Cell& other);

            /// Returns true if the cell is a leaf
            HK_INLINE bool isLeaf() const;

            /// Data pointer access
            HK_INLINE _Ret_notnull_ FaceId* accessFaceIdsPointer();
            HK_INLINE _Ret_notnull_ VertexId* accessVertexIdsPointer();
            HK_INLINE _Ret_notnull_ EdgeId* accessEdgeIdsPointer();

            HK_INLINE _Ret_notnull_ const FaceId* getFaceIdsPointer() const;
            HK_INLINE _Ret_notnull_ const VertexId* getVertexIdsPointer() const;
            HK_INLINE _Ret_notnull_ const EdgeId* getEdgeIdsPointer() const;

            /// Data value access
            HK_INLINE FaceId getFaceId(int i) const;
            HK_INLINE VertexId getVertexId(int i) const;
            HK_INLINE EdgeId getEdgeId(int i) const;

            HK_INLINE hkUint32 getNumFaces() const;
            HK_INLINE hkUint32 getNumVertices() const;
            HK_INLINE hkUint32 getNumEdges() const;

            /// Change data size (dynamic cells only)
            HK_INLINE void setNumFaces(hkUint32 size);
            HK_INLINE void setNumVertices(hkUint32 size);
            HK_INLINE void setNumEdges(hkUint32 size);
            HK_INLINE void setSizes(hkUint32 numFaces, hkUint32 numVertices, hkUint32 numEdges);

            /// Gets / Sets the cell label
            HK_INLINE Labels getLabel() const;
            HK_INLINE void setLabel(Labels l);

            /// Returns true if the cell is empty / solid / unknown
            HK_INLINE int isEmpty() const;
            HK_INLINE int isSolid() const;
            HK_INLINE int isUnknown() const;
            HK_INLINE int isVisited() const;

            /// Sets the cell as empty / solid
            HK_INLINE void setEmpty();
            HK_INLINE void setSolid();
            HK_INLINE void setVisited(bool visited);
            HK_INLINE void setLeaf(bool leaf);

            /// Gets / Sets user data
            HK_INLINE hkUint32 getUserData() const;
            HK_INLINE void setUserData(hkUint32 data);


        protected:

            hkUint32 m_userData;
            hkArray<hkUint32> m_faces;
            hkArray<hkUint32> m_vertices;
            hkArray<hkUint32> m_edges;
            CellId m_prevCellId;
            CellId m_nextCellId;
            hkUint32 m_flags;
        };

    public:

        /// Constructor
        hkcdNewCellsCollection()
        :   m_firstCellId(CellId::invalid())
        ,   m_lastCellId(CellId::invalid())
        {}

        /// Retrieves the cell at the given Id.
        HK_INLINE const Cell& getCell(CellId cellId) const;
        HK_INLINE Cell& accessCell(CellId cellId);

        // Allocates a cell having the given number of boundary polygons
        HK_INLINE CellId allocCell();

        /// Frees the given cell
        HK_INLINE void freeCell(CellId cellId);

        /// Copy data
        HK_INLINE void copy(const hkcdNewCellsCollection& other);

    public:

        /// Returns the first valid cell Id
        HK_INLINE CellId getFirstCellId() const;

        /// Returns the last valid cell Id
        HK_INLINE CellId getLastCellId() const;

        /// Returns the next valid cell Id
        HK_INLINE CellId getNextCellId(CellId cellId) const;

        /// Returns the previous valid cell Id
        HK_INLINE CellId getPrevCellId(CellId cellId) const;

    protected:

        hkArray<Cell> m_cells;
        CellId m_firstCellId;
        CellId m_lastCellId;
        hkArray<int> m_freeCells;

    protected:
        
        void operator=(const hkcdNewCellsCollection&);
};

#include <Geometry/Collide/DataStructures/Planar/Memory/hkcdNewCellsCollection.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
