// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE hkcdPlanarGeometry::PolygonId hkcdPlanarGeometry::addPolygon(PlaneId supportPlane, const Material& materialIn, int numBounds)
{
    const PolygonId newPolyId   = m_polys->alloc(supportPlane, materialIn, numBounds);
    if ( !newPolyId.isValid() )
    {
        return PolygonId::invalid();
    }

    Polygon& newPoly            = accessPolygon(newPolyId);

    // init the vertices ids
    for (int i = 0 ; i < numBounds ; i++)
    {
        newPoly.setVertexId(i, VertexId::invalid());
    }
    return newPolyId;
}

HK_INLINE const hkcdPlanarGeometry::Polygon& hkcdPlanarGeometry::getPolygon(PolygonId polyId) const
{
    return m_polys->getPolygon(polyId);
}

HK_INLINE hkcdPlanarGeometry::Polygon& hkcdPlanarGeometry::accessPolygon(PolygonId polyId)
{
    return m_polys->accessPolygon(polyId);
}

//
//  Computes the number of boundary planes

HK_INLINE int hkcdPlanarGeometry::getNumBoundaryPlanes(PolygonId polyId) const
{
    return m_polys->getNumBoundaryPlanes(polyId);
}

//
//  Returns the collection of polygons

HK_INLINE const hkcdPlanarGeometryPolygonCollection& hkcdPlanarGeometry::getPolygons() const    {   return *m_polys;    }
HK_INLINE hkcdPlanarGeometryPolygonCollection& hkcdPlanarGeometry::accessPolygons()         {   return *m_polys;    }
HK_INLINE void hkcdPlanarGeometry::setPolygons(_In_ hkcdPlanarGeometryPolygonCollection* polys) { m_polys = polys; }

//
//  Gets the plane collection associated with this geometry

HK_INLINE _Ret_maybenull_ const hkcdPlanarGeometryPlanesCollection* hkcdPlanarGeometry::getPlanesCollection() const {   return m_planes;    }
HK_INLINE _Ret_maybenull_ hkcdPlanarGeometryPlanesCollection* hkcdPlanarGeometry::accessPlanesCollection()          {   return m_planes;    }

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
