// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

//
//  Returns the cell with the given Id

HK_INLINE const hkcdConvexCellsTree3D::Cell& hkcdConvexCellsTree3D::getCell(CellId cellId) const    {   return m_cells->getCell(cellId);        }
HK_INLINE hkcdConvexCellsTree3D::Cell& hkcdConvexCellsTree3D::accessCell(CellId cellId)         {   return m_cells->accessCell(cellId);     }

//
//  Enables / disables the collection of connectivity information during the building of the tree.

HK_INLINE void hkcdConvexCellsTree3D::enableConnectivityCollection(bool doEnable)
{
    m_buildCellConnectivity = doEnable;
}

//
//  Returns whether the tree has been built with connectivity information

HK_INLINE bool hkcdConvexCellsTree3D::hasManifoldCells() const
{
    return m_buildCellConnectivity;
}

//
//  Data access

HK_INLINE _Ret_notnull_ hkcdConvexCellsTree3D::Vertex* hkcdConvexCellsTree3D::Data::accessVertices()
{
    return m_vertices.begin();
}

HK_INLINE _Ret_notnull_ hkcdConvexCellsTree3D::Edge* hkcdConvexCellsTree3D::Data::accessEdges()
{
    return m_edges.begin();
}

HK_INLINE _Ret_notnull_ hkcdConvexCellsTree3D::Face* hkcdConvexCellsTree3D::Data::accessFaces()
{
    return m_faces.begin();
}

HK_INLINE hkcdConvexCellsTree3D::Vertex& hkcdConvexCellsTree3D::Data::allocateNewVertex(VertexId& newVertexId)
{
    if ( m_freeVerticesId.getSize() )
    {
        newVertexId = m_freeVerticesId[0];
        m_freeVerticesId.removeAt(0);
    }
    else
    {
        newVertexId = m_vertices.getSize();
        m_vertices.expandOne();
    }
    return m_vertices[newVertexId];
}

HK_INLINE hkcdConvexCellsTree3D::Edge& hkcdConvexCellsTree3D::Data::allocateNewEdge(EdgeId& newEdgeId)
{
    if ( m_freeEdgesId.getSize() )
    {
        newEdgeId = m_freeEdgesId[0];
        m_freeEdgesId.removeAt(0);
    }
    else
    {
        newEdgeId = m_edges.getSize();
        m_edges.expandOne();
    }

    Edge& newEdge = m_edges[newEdgeId];
    // inits
    {
        newEdge.m_otherPlaneId          = PlaneId::invalid();
        newEdge.m_nextCoincidentEdgeId  = EdgeId(-1);
        newEdge.m_firstEdgeOfChainId    = newEdgeId;
        newEdge.m_owningCellId          = CellId::invalid();
        newEdge.m_indexInCell           = -1;
    }
    return m_edges[newEdgeId];
}

HK_INLINE hkcdConvexCellsTree3D::Face& hkcdConvexCellsTree3D::Data::allocateNewFace(FaceId& newFaceId)
{
    if ( m_freeFacesId.getSize() )
    {
        newFaceId = m_freeFacesId[0];
        m_freeFacesId.removeAt(0);
    }
    else
    {
        newFaceId = m_faces.getSize();
        m_faces.expandOne();
    }

    // Clear flags
    m_faces[newFaceId].m_flags = 0;

    return m_faces[newFaceId];
}

HK_INLINE int hkcdConvexCellsTree3D::Data::getNumAllocatedVertices() const
{
    return m_vertices.getSize();
}

HK_INLINE int hkcdConvexCellsTree3D::Data::getNumAllocatedEdges() const
{
    return m_edges.getSize();
}

HK_INLINE int hkcdConvexCellsTree3D::Data::getNumAllocatedFaces() const
{
    return m_faces.getSize();
}

HK_INLINE void hkcdConvexCellsTree3D::Data::freeVertex(VertexId vertexId)
{
    m_freeVerticesId.pushBack(vertexId);

    m_vertices[vertexId].m_planeIds[0] = PlaneId::invalid();

#ifdef HK_DEBUG
    m_vertices[vertexId].m_planeIds[1] = PlaneId::invalid();
    m_vertices[vertexId].m_planeIds[2] = PlaneId::invalid();
#endif
}

HK_INLINE void hkcdConvexCellsTree3D::Data::freeEdge(EdgeId edgeId)
{
    m_freeEdgesId.pushBack(edgeId);

    // Mark edge as being invalid
    m_edges[edgeId].m_vertexIds[0]          = VertexId(-1);

#ifdef HK_DEBUG
    m_edges[edgeId].m_faceIds[0]            = FaceId(-1);
    m_edges[edgeId].m_faceIds[1]            = FaceId(-1);
    m_edges[edgeId].m_vertexIds[1]          = VertexId(-1);
    m_edges[edgeId].m_otherPlaneId          = PlaneId::invalid();
    m_edges[edgeId].m_nextCoincidentEdgeId  = EdgeId(-1);
    m_edges[edgeId].m_firstEdgeOfChainId    = EdgeId(-1);
    m_edges[edgeId].m_owningCellId          = CellId::invalid();
    m_edges[edgeId].m_indexInCell           = -1;
#endif
}

HK_INLINE void hkcdConvexCellsTree3D::Data::freeFace(FaceId faceId)
{
    m_freeFacesId.pushBack(faceId);

    m_faces[faceId].m_planeId       = PlaneId::invalid();

#ifdef HK_DEBUG
    m_faces[faceId].m_negCellId     = CellId::invalid();
    m_faces[faceId].m_posCellId     = CellId::invalid();
#endif
}

//
//  Returns plane id with correct orientation given a face and cellId

HK_INLINE hkcdConvexCellsTree3D::PlaneId hkcdConvexCellsTree3D::getCellFacePlaneId(const Face& face, CellId cellId) const
{
    HK_ASSERT_NO_MSG(0x2a3cc2e3, face.m_negCellId == cellId || face.m_posCellId == cellId);
    return ( face.m_negCellId == cellId ) ? face.m_planeId : hkcdPlanarGeometryPrimitives::getOppositePlaneId(face.m_planeId);
}

//
//  Helper to link to given edges during connectivity build

HK_INLINE void hkcdConvexCellsTree3D::linkEdges(EdgeId edgeToLinkId, EdgeId edgeRefId)
{
    if (m_buildCellConnectivity)
    {
        Edge& edgeToLink = m_data->accessEdges()[edgeToLinkId];
        Edge& edgeRef = m_data->accessEdges()[edgeRefId];
        edgeToLink.m_firstEdgeOfChainId = edgeRef.m_firstEdgeOfChainId;
        HK_ASSERT_NO_MSG(0x2a3cc2f4, edgeToLink.m_nextCoincidentEdgeId == hkUint32(-1) );
        Edge* curEdge = &edgeRef;
        while ( int(curEdge->m_nextCoincidentEdgeId) != -1 )
        {
            curEdge = &m_data->accessEdges()[curEdge->m_nextCoincidentEdgeId];
        }
        curEdge->m_nextCoincidentEdgeId = edgeToLinkId;
    }
}

//
//  Helper to update the linked list f chained edges with a new edgeId

HK_INLINE void hkcdConvexCellsTree3D::replaceEdgeInLinkedChain(EdgeId edgeToReplaceId, EdgeId replacingEdgeId)
{
    if ( m_buildCellConnectivity )
    {
        Edge& edgeToReplace = m_data->accessEdges()[edgeToReplaceId];
        Edge& replacingEdge = m_data->accessEdges()[replacingEdgeId];

        // If it happens that we replace the first link, update the whole list
        if (edgeToReplace.m_firstEdgeOfChainId == edgeToReplaceId)
        {
            Edge* curEdge = &edgeToReplace;
            while ( int(curEdge->m_nextCoincidentEdgeId) != -1 )
            {
                curEdge = &m_data->accessEdges()[curEdge->m_nextCoincidentEdgeId];
                curEdge->m_firstEdgeOfChainId = replacingEdgeId;
            }
            replacingEdge.m_firstEdgeOfChainId = replacingEdgeId;
        }
        else
        {
            Edge* curEdge = &m_data->accessEdges()[edgeToReplace.m_firstEdgeOfChainId];
            while (curEdge->m_nextCoincidentEdgeId != edgeToReplaceId)
            {
                curEdge = &m_data->accessEdges()[curEdge->m_nextCoincidentEdgeId];
            }
            curEdge->m_nextCoincidentEdgeId = replacingEdgeId;
            replacingEdge.m_firstEdgeOfChainId = edgeToReplace.m_firstEdgeOfChainId;
        }

        replacingEdge.m_nextCoincidentEdgeId = edgeToReplace.m_nextCoincidentEdgeId;
    }
}

//
//  Check if two neighboring cells can be reached

HK_INLINE bool hkcdConvexCellsTree3D::canGoFromCellThroughFace(CellId fromCellId, FaceId throughFaceId, bool fromOutside)
{
    const Face& face = m_data->accessFaces()[throughFaceId];

    // Quick exits
    if ( face.getSurfaceType() == FACE_SURFACE_OPEN )       return true;
    if ( face.getSurfaceType() == FACE_SURFACE_WATERTIGHT ) return false;

    // Check if we are going in the right direction
    const PlaneId polyPlaneId           = face.m_planeId;
    const PlaneId cellPolyPlaneId       = ( face.m_posCellId == fromCellId )                ? polyPlaneId : hkcdPlanarGeometryPrimitives::getOppositePlaneId(polyPlaneId);
    const PlaneId surfacePlaneId        = ( face.getSurfaceType() == FACE_SURFACE_DIRECT )  ? polyPlaneId : hkcdPlanarGeometryPrimitives::getOppositePlaneId(polyPlaneId);
    const bool surfaceTowardsCell       = ( cellPolyPlaneId == surfacePlaneId );

    return ( fromOutside ) ? surfaceTowardsCell : !surfaceTowardsCell;
}

//
//  Accessor to the plane collection

HK_INLINE _Ret_notnull_ const hkcdPlanarGeometryPlanesCollection* hkcdConvexCellsTree3D::getPlanesCollection() const
{
    return m_planes;
}

//
//  Returns whether repaint face material events occured during the splitting of the cells

HK_INLINE bool hkcdConvexCellsTree3D::hasRepaintedFaces() const
{
    return m_hasRepaintedFaces;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
