// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

//
//  Constructor

template <class CT, class IDT, class CS>
hkcdConvexCellsTree<CT, IDT, CS>::hkcdConvexCellsTree()
{
    m_cells.setAndDontIncrementRefCount(new CS());
}

//
//  Constructor 2

template <class CT, class IDT, class CS>
hkcdConvexCellsTree<CT, IDT, CS>::
hkcdConvexCellsTree(_In_ CS* cells)
:   m_cells(cells)
{}

//
//  Copy constructor. The geometry will not be shared!

template <class CT, class IDT, class CS>
hkcdConvexCellsTree<CT, IDT, CS>::hkcdConvexCellsTree(const hkcdConvexCellsTree& other)
:   hkcdPlanarEntity(other)
{
    // Copy the cells
    m_cells.setAndDontIncrementRefCount(new CS());
    m_cells->copy(*other.m_cells);
}

//
//  Returns the cells collection

template <class CT, class IDT, class CS>
HK_INLINE _Ret_notnull_ const CS* hkcdConvexCellsTree<CT, IDT, CS>::getCells() const { return m_cells; }

template <class CT, class IDT, class CS>
HK_INLINE _Ret_notnull_ CS* hkcdConvexCellsTree<CT, IDT, CS>::accessCells()         {   return m_cells; }

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
