// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_HAVOK_ASSEMBLY_EXCLUDE_FILE

#pragma once

#include <Geometry/Collide/DataStructures/Planar/Solid/hkcdPlanarSolid.h>
#include <Geometry/Collide/DataStructures/IntAabb/hkcdIntAabb.h>

#include <Common/Base/Container/LocalArray/hkLocalBuffer.h>
#include <Common/Base/Algorithm/Collide/1AxisSweep/hk1AxisSweep.h>

class hkcdPlanarSolid;

/// Base class for a convex cells tree
template <class CellType, class CellIdType, class CellStorage>
class hkcdConvexCellsTree : public hkcdPlanarEntity
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY);

    public:

        // Types
        typedef CellType                    Cell;
        typedef CellIdType                  CellId;
        typedef hkcdPlanarSolid::NodeId     NodeId;
        typedef hkcdPlanarSolid::Node       Node;
        typedef PlanesCollection::Bounds    Bounds;

    public:

        /// Constructor
        hkcdConvexCellsTree();

        /// Constructor from data pointers
        hkcdConvexCellsTree(_In_ CellStorage* cells);

        /// Copy constructor. The geometry will not be shared!
        hkcdConvexCellsTree(const hkcdConvexCellsTree& other);

    public:

        /// Returns the cells collection
        HK_INLINE _Ret_notnull_ const CellStorage* getCells() const;
        HK_INLINE _Ret_notnull_ CellStorage* accessCells();

    protected:

        hkRefPtr<CellStorage> m_cells;          ///< The array of cells
};

#include <Geometry/Collide/DataStructures/Planar/ConvexCellsTree/hkcdConvexCellsTree.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
