// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_HAVOK_ASSEMBLY_EXCLUDE_FILE

#pragma once

#include <Common/Base/Thread/TaskQueue/hkTask.h>

#include <Geometry/Collide/DataStructures/Planar/CSG/hkcdPlanarCsgOperand.h>
#include <Geometry/Collide/DataStructures/Planar/Memory/hkcdPlanarGeometryPrimitivesCollectionManager.h>

/// Utility for computing boolean operations between planar geometries
namespace hkcdPlanarGeometryBooleanUtil
{
    // Types
    typedef hkcdPlanarGeometry::PlaneId                 PlaneId;
    typedef hkcdPlanarGeometry::Polygon                 Polygon;
    typedef hkcdPlanarGeometry::PolygonId               PolygonId;
    typedef hkcdPlanarGeometryPrimitives::CollectionManager<hkcdPlanarGeometryPolygonCollection>    PolyCollManager;

    /// Supported operations
    enum Operation
    {
        OP_UNION            = 0,    ///< Computes the union of A and B
        OP_INTERSECTION     = 1,    ///< Computes the intersection of A and B
        OP_DIFFERENCE       = 2,    ///< Computes the difference A - B
    };

    /// Boolean state, to be maintained between operations
    struct BooleanState
    {};

    /// Computes A op B. Will assert if called with OP_DIFFERENCE, as that would require flipping the solidB.
    HK_EXPORT_COMMON void HK_CALL compute(_In_opt_ const hkTask::ExecutionContext* executionCtx, _In_opt_ const hkcdPlanarCsgOperand* operandA, Operation op, _In_opt_ const hkcdPlanarCsgOperand* operandB,
        _Inout_opt_ hkRefPtr<const hkcdPlanarCsgOperand>* resultOut, _Inout_opt_ hkRefPtr<const hkcdPlanarCsgOperand>* dualResultOut, bool dynamicSplit);
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
