// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

//
//  Gets / sets the dangling geometry

_Ret_maybenull_
HK_INLINE const hkcdPlanarGeometry* hkcdPlanarCsgOperand::getDanglingGeometry() const
{
    return m_danglingGeometry;
}

_Ret_maybenull_
HK_INLINE hkcdPlanarGeometry* hkcdPlanarCsgOperand::accessDanglingGeometry()
{
    return m_danglingGeometry;
}

HK_INLINE void hkcdPlanarCsgOperand::setDanglingGeometry(_In_opt_ hkcdPlanarGeometry* geom)
{
    m_danglingGeometry = geom;
}

//
//  Gets / sets the solid

_Ret_maybenull_
HK_INLINE const hkcdPlanarSolid* hkcdPlanarCsgOperand::getSolid() const
{
    HK_ASSERT_NO_MSG(0x6be09d91, !m_regions || !m_solid || m_regions->getPlanesCollection() == m_solid->getPlanesCollection());
    return m_solid;
}

_Ret_maybenull_
HK_INLINE hkcdPlanarSolid* hkcdPlanarCsgOperand::accessSolid()
{
    HK_ASSERT_NO_MSG(0x67e41692, !m_regions || !m_solid || m_regions->getPlanesCollection() == m_solid->getPlanesCollection());
    return m_solid;
}

HK_INLINE void hkcdPlanarCsgOperand::setSolid(_In_opt_ hkcdPlanarSolid* solid)
{
    m_solid = solid;
}

//
//  Retrieves the common, shared planes collection

HK_INLINE _Ret_maybenull_ hkcdPlanarGeometryPlanesCollection* hkcdPlanarCsgOperand::accessPlanesCollection()
{
    const hkcdPlanarGeometryPlanesCollection* planesCol = getPlanesCollection();
    return const_cast<hkcdPlanarGeometryPlanesCollection*>(planesCol);
}

//
//  Gets / sets the regions

_Ret_maybenull_
HK_INLINE const hkcdConvexCellsTree3D* hkcdPlanarCsgOperand::getRegions() const
{
    HK_ASSERT_NO_MSG(0xd18532d, !m_regions || !m_solid || m_regions->getPlanesCollection() == m_solid->getPlanesCollection());
    return m_regions;
}

_Ret_maybenull_
HK_INLINE hkcdConvexCellsTree3D* hkcdPlanarCsgOperand::accessRegions()
{
    HK_ASSERT_NO_MSG(0x3f373b82, !m_regions || !m_solid || m_regions->getPlanesCollection() == m_solid->getPlanesCollection());
    return m_regions;
}

HK_INLINE void hkcdPlanarCsgOperand::setRegions(_In_opt_ hkcdConvexCellsTree3D* regions)
{
    HK_ASSERT_NO_MSG(0x664695a9, !regions || !m_solid || regions->getPlanesCollection() == m_solid->getPlanesCollection());
    m_regions = regions;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
