// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_HAVOK_ASSEMBLY_EXCLUDE_FILE

#pragma once

#include <Common/Base/Thread/TaskQueue/hkTask.h>

#include <Geometry/Collide/DataStructures/Planar/ConvexCellsTree/hkcdConvexCellsTree3D.h>
#include <Geometry/Collide/DataStructures/Planar/Memory/hkcdPlanarGeometryPrimitivesCollectionManager.h>

/// CSG Operand
class HK_EXPORT_COMMON hkcdPlanarCsgOperand : public hkReferencedObject
{
    //+version(1)

    public:

        HK_DECLARE_CLASS(hkcdPlanarCsgOperand, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::IncludeInMgd(false));

        // Types
        typedef hkcdPlanarGeometryPlanesCollection      PlanesCollection;
        typedef hkTask::ExecutionContext                ExecutionContext;
        typedef hkcdPlanarEntity::TriangleProviderId    TriangleProviderId;
        typedef hkcdPlanarGeometryPrimitives::CollectionManager<hkcdPlanarGeometryPolygonCollection>    PolyCollManager;
        typedef hkcdPlanarGeometryPrimitives::CollectionManager<hkcdPlanarSolid::ArrayMgr>              ArrayCollManager;

    public:

        /// Constructor
        hkcdPlanarCsgOperand();

        /// Serialization constructor
        void afterReflectNew();

        /// Destructor
        virtual ~hkcdPlanarCsgOperand();

    public:

        /// Returns the convex cell tree corresponding to this solid planar geom. Build it if necessary.
        _Ret_notnull_ hkcdConvexCellsTree3D* getOrCreateConvexCellTree(_In_opt_ const ExecutionContext* executionCtx, bool withConnectivity/* = false*/, bool rebuildIfConnectivityDoesntMatch/* = true*/);

        /// Retrieves the planes collection
        HK_INLINE _Ret_maybenull_ PlanesCollection* accessPlanesCollection();
        _Ret_maybenull_ const PlanesCollection* getPlanesCollection() const;

        /// Sets a new planes collection. If the plane remapping table is non-null, the plane Ids on all nodes will be re-set as well (i.e. to match the plane Ids in the new collection)
        void setPlanesCollection(_In_opt_ const PlanesCollection* newPlanes, _In_reads_(_Inexpressible_()) const int* HK_RESTRICT planeRemapTable);

        /// Shift all plane ids of the operand elements
        void shiftPlaneIds(int offsetValue);

        /// Remaps the materials triangle source Ids
        void remapTriangleProviderIds(const hkArray<TriangleProviderId>& triSrcIdRemap);

        /// Simplifies this operand by rebuilding the solid BSP tree from its boundaries
        hkResult simplifyFromBoundaries(_In_opt_ const ExecutionContext* executionCtx);

        /// Builds dangling geometry form input operand and bool operation
        void buildDanglingGeometry(bool split, bool negPart, _In_ const hkcdPlanarSolid* cutoutSolid);

        /// Removes all planes not used by the entities
        void removeUnusedPlanes();

        /// Copy the desired data from another operand
        void copyData(const hkcdPlanarCsgOperand& operandSrc, bool copyRegions = false);

        /// Copy the desired data from another operand, using provided collection managers
        void shallowCopyData(const hkcdPlanarCsgOperand& operandSrc, _In_ const hkcdPlanarGeometryPlanesCollection* dstPlaneCollection);

        /// Create an operand with the same data, but a duplicated plane collection
        static void HK_CALL createOperandWithSharedDataAndClonedPlanes(_In_ const hkcdPlanarCsgOperand* operandSrc, hkRefPtr<hkcdPlanarCsgOperand>& operandDst);

    protected:

        /// Collects a bit-field of plane Ids used by the operand
        void collectUsedPlaneIds(hkBitField& usedPlaneIdsOut) const;

    public:

        /// Gets / sets the dangling geometry
        HK_INLINE _Ret_maybenull_ const hkcdPlanarGeometry* getDanglingGeometry() const;
        HK_INLINE _Ret_maybenull_ hkcdPlanarGeometry* accessDanglingGeometry();
        HK_INLINE void setDanglingGeometry(_In_opt_ hkcdPlanarGeometry* geom);

        /// Gets / sets the solid
        HK_INLINE _Ret_maybenull_ const hkcdPlanarSolid* getSolid() const;
        HK_INLINE _Ret_maybenull_ hkcdPlanarSolid* accessSolid();
        HK_INLINE void setSolid(_In_opt_ hkcdPlanarSolid* solid);

        /// Gets / sets the regions
        HK_INLINE _Ret_maybenull_ const hkcdConvexCellsTree3D* getRegions() const;
        HK_INLINE _Ret_maybenull_ hkcdConvexCellsTree3D* accessRegions();
        HK_INLINE void setRegions(_In_opt_ hkcdConvexCellsTree3D* regions);

    protected:

        /// Solid boundary representation of the fracture piece
        hkRefPtr<hkcdPlanarSolid> m_solid;

        /// "Dangling" part of the geometry
        hkRefPtr<hkcdPlanarGeometry> m_danglingGeometry;

        /// A tree of convex regions matching the solid
        hkRefPtr<hkcdConvexCellsTree3D> m_regions
            HK_ATTR(hk::OpaqueType);
};

#include <Geometry/Collide/DataStructures/Planar/CSG/hkcdPlanarCsgOperand.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
