// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/hkBase.h>
#include <Common/Base/Math/Vector/hkIntVector.h>

/// Integer coordinates AABB
struct HK_EXPORT_COMMON hkcdIntAabb
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY, hkcdIntAabb);

    public:

        /// Sets this = empty AABB
        HK_INLINE void setEmpty();

        /// Enlarges the AABB to include the given point
        HK_INLINE void includePoint(hkIntVectorParameter v);

        /// Expands the box by the given radius
        HK_INLINE void expandBy(int radius);

        /// Returns true if the point is inside the AABB
        HK_INLINE hkBool32 containsPoint(hkIntVectorParameter v) const;

        /// Sets the AABB to be the intersection AABB of the two given input AABBs.
        /// The result can be invalid if the two input AABBs do not overlap. Use isEmpty() to verify this.
        HK_INLINE void setIntersection(const hkcdIntAabb& aabb0, const hkcdIntAabb& aabb1);

        /// Returns true if the AABB is empty, e.g., its min is greater than its max for any dimension.
        HK_INLINE bool isEmpty() const;

    public:

        hkIntVector m_min;
        hkIntVector m_max;
};

#include <Geometry/Collide/DataStructures/IntAabb/hkcdIntAabb.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
