// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

//
template <typename STORAGE>
template <typename QUERY>
HK_INLINE void      hkcdDynamicTree::Tree<STORAGE>::processLeaf(QUERY& q, const NodeContext& leaf) const
{
    q.processLeaf(leaf);
}

//
template <typename STORAGE>
HK_INLINE const typename hkcdDynamicTree::Tree<STORAGE>::Node*  hkcdDynamicTree::Tree<STORAGE>::getNode(Index node, bool useCache) const
{
    HK_ASSERT(0xC53DB6F6,node,"Null node index");
    {
        return STORAGE::getNodesBuffer()+node;
    }
}

//
// Queries support.
//

//
template <typename STORAGE>
HK_INLINE void      hkcdDynamicTree::Tree<STORAGE>::initializeRootContext(NodeContext& context, bool useCache) const
{
    setContextFromSlot(m_root, context, useCache);
}

//
template <typename STORAGE>
HK_INLINE void      hkcdDynamicTree::Tree<STORAGE>::fetchChildren(const NodeContext& context, NodeContext* children, bool useCache) const
{
    setContextFromSlot(context.m_node->getChild(0), children[0], useCache);
    setContextFromSlot(context.m_node->getChild(1), children[1], useCache);
}

//
template <typename STORAGE>
HK_INLINE void      hkcdDynamicTree::Tree<STORAGE>::setContextFromSlot(const Slot& slot, NodeContext& context, bool useCache) const
{
    context.m_index = slot;
    context.m_node = getNode(slot, useCache);
    context.m_node->getAabb(context.m_aabb);
}

//
template <typename STORAGE>
HK_INLINE void      hkcdDynamicTree::Tree<STORAGE>::setContextFromNode(Index node, NodeContext& contextOut, bool useCache) const
{
    contextOut.m_index  =   node;
    contextOut.m_node   =   getNode(node, useCache);
    contextOut.m_node->getAabb(contextOut.m_aabb);
}

//
template <typename STORAGE>
HK_INLINE void      hkcdDynamicTree::Tree<STORAGE>::setSlotFromContext(const NodeContext& context, Slot& slot) const
{
    slot = context.m_index;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
