// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#include <Common/Base/Math/Vector/hkIntVector.h>
#include <Common/Base/Math/Vector/hkFourTransposedPoints.h>
#include <Geometry/Collide/Types/hkcdVertex.h>

/// Returns the furthest vertex in the given direction. Selects the fastest method for each platform.
/// The number of input vertices must be a minimum of 4, however the numVertices can be less (the function
/// will assert if the padded vertices are missing).
HK_ALWAYS_INLINE void HK_CALL hkcdSupportingVertexPoints(
    const hkcdVertex* vertices, int numVertices, hkVector4Parameter direction, hkcdVertex* HK_RESTRICT vertexOut );

// -------------------------------------------------------------------------------------------------------------
// Implementations
// -------------------------------------------------------------------------------------------------------------

/// Returns the furthest vertex in the given direction.
/// Usually vertices will have their index stored in the w component, so both the vertexOut contains both the point and index in the w component.
/// The numberVertices must be a multiple of 4, duplicate the last one if necessary.
HK_INLINE void HK_CALL hkcdSupportingVertexPointsSimple(
    const hkcdVertex* HK_RESTRICT vertices, int numVertices, hkVector4Parameter direction,
    hkcdVertex* HK_RESTRICT vertexOut );


/// Returns the furthest vertex in the given direction.
/// The vertexOut contains both the point and index in the w component.
HK_INLINE void HK_CALL hkcdSupportingVertexPointsTranposed(
    const hkFourTransposedPoints* HK_RESTRICT transposedVertices, int numTransposedVertices, hkVector4Parameter direction,
    hkcdVertex* HK_RESTRICT vertexOut );

/// Returns the furthest vertex in the given direction.
/// This version transposes the vertices in place, the number of vertices do not need to be padded, but must be at least 4
/// returns the vertex used, so far seems to be the fastest on Intel
HK_INLINE void HK_CALL hkcdSupportingVertexPointsTransposeInplace(
    const hkcdVertex* HK_RESTRICT vertices, int numVertices, hkVector4Parameter direction,
    hkcdVertex* HK_RESTRICT vertexOut );


#include <Geometry/Collide/Algorithms/SupportingVertex/hkcdSupportingVertex.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
