// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Geometry/Collide/hkcdCollide.h>
#include <Geometry/Collide/Algorithms/Intersect/hkcdIntersectTriangleTriangle.h>
#include <Common/Base/Math/Vector/hkVector4Util.h>

    //
    //  Interval class. Encodes and implements operations on 4 intervals
struct hkcdInterval4
{
    public:

        HK_DECLARE_CLASS(hkcdInterval4, NewOpaque);

            // Sets the intervals from the vertices
        HK_INLINE hkcdInterval4(hkVector4Parameter d0, hkVector4Parameter d1, hkVector4Parameter d2, hkVector4Parameter d3, const hkVector4* verts);

            // Intersects the interval with another one
        HK_INLINE hkVector4Comparison intersect(const hkcdInterval4& span);

    public:

        hkVector4 m_min;
        hkVector4 m_max;
};

//
//  Sets the intervals from the vertices

inline hkcdInterval4::hkcdInterval4(hkVector4Parameter d0, hkVector4Parameter d1, hkVector4Parameter d2, hkVector4Parameter d3, const hkVector4* verts)
{
    hkVector4 tmp0; hkVector4Util::dot3_1vs4(verts[0], d0, d1, d2, d3, tmp0);
    hkVector4 tmp1; hkVector4Util::dot3_1vs4(verts[1], d0, d1, d2, d3, tmp1);
    hkVector4 tmp2; hkVector4Util::dot3_1vs4(verts[2], d0, d1, d2, d3, tmp2);

    m_min.setMin(tmp0, tmp1);
    m_max.setMax(tmp0, tmp1);
    m_min.setMin(m_min, tmp2);
    m_max.setMax(m_max, tmp2);
}

//
//  Intersects the interval with another one

inline hkVector4Comparison hkcdInterval4::intersect(const hkcdInterval4& span)
{
    hkVector4Comparison cmp;
    cmp.setAnd(m_min.lessEqual(span.m_max), m_max.greaterEqual(span.m_min));
    return cmp;
}

//
//  Updates the intersection

HK_INLINE static void updateIntersection(hkVector4Parameter d0, hkVector4Parameter d1, hkVector4Parameter d2, hkVector4Parameter d3,
                                               const hkVector4* triA, const hkVector4* triB, hkVector4Comparison& cmpInOut)
{
    hkcdInterval4 spanA(d0, d1, d2, d3, triA);
    hkcdInterval4 spanB(d0, d1, d2, d3, triB);

    cmpInOut.setAnd(cmpInOut, spanA.intersect(spanB));
}

//
//  Tests the intersection between two triangles. Triangle vertices are (A, B, C), and (D, E, F)

hkBool32 HK_CALL hkcdIntersectTriangleTriangle(const hkVector4 (&triangleA)[3], const hkVector4 (&triangleB)[3])
{
    hkVector4 vAB;  vAB.setSub(triangleA[1], triangleA[0]);
    hkVector4 vBC;  vBC.setSub(triangleA[2], triangleA[1]);
    hkVector4 vCA;  vCA.setSub(triangleA[0], triangleA[2]);

    hkVector4 vDE;  vDE.setSub(triangleB[1], triangleB[0]);
    hkVector4 vEF;  vEF.setSub(triangleB[2], triangleB[1]);
    hkVector4 vFD;  vFD.setSub(triangleB[0], triangleB[2]);

    // Init comparison mask
    hkVector4Comparison cmp;
    cmp.set<hkVector4ComparisonMask::MASK_XYZW>();

    // Compute SAT directions (4 at a time)
    hkVector4 d0, d1, d2, d3;
    hkVector4Util::cross_4vs1(  vAB, vBC, vCA, vFD,
                                vDE,
                                d0, d1, d2, d3);
    updateIntersection(d0, d1, d2, d3, triangleA, triangleB, cmp);

    hkVector4Util::cross_3vs1(vAB, vBC, vCA, vEF, d0, d1, d2);
    d3.setSub(triangleA[0], triangleB[0]);
    updateIntersection(d0, d1, d2, d3, triangleA, triangleB, cmp);

    hkVector4Util::cross_3vs1(vAB, vBC, vCA, vFD, d0, d1, d2);
    d3.setSub(triangleA[0], triangleB[1]);
    updateIntersection(d0, d1, d2, d3, triangleA, triangleB, cmp);

    d0.setCross(vCA, vAB);
    d1.setSub(triangleA[0], triangleB[2]);
    d2.setSub(triangleA[1], triangleB[0]);
    d3.setSub(triangleA[1], triangleB[1]);
    updateIntersection(d0, d1, d2, d3, triangleA, triangleB, cmp);

    d0.setSub(triangleA[1], triangleB[2]);
    d1.setSub(triangleA[2], triangleB[0]);
    d2.setSub(triangleA[2], triangleB[1]);
    d3.setSub(triangleA[2], triangleB[2]);
    updateIntersection(d0, d1, d2, d3, triangleA, triangleB, cmp);

    // All test must have succeeded!
    return cmp.allAreSet();
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
