// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#include <Geometry/Collide/Types/hkcdRay.h>
#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>
#include <Common/Base/Math/Vector/hkFourTransposedPoints.h>

    /// Returns true if the ray intersects the AABB.
HK_INLINE   hkBool32    hkcdIntersectRayAabb(const struct hkcdRay& ray, const hkAabb& aabb, hkSimdReal* HK_RESTRICT fractionInOut);

HK_INLINE   hkVector4Comparison hkcdIntersectRayAabbBundle(const hkcdRay& ray,
                                                        const hkFourTransposedPoints& aabbMin, const hkFourTransposedPoints& aabbMax,
                                                        const hkVector4& fraction);


    /// Returns true if the ray starting at the origin intersects the AABB.
HK_INLINE   hkBool32    hkcdRayDirectionAabbIntersect(hkVector4Parameter rayInvDirection, const hkAabb& aabb, hkSimdReal* HK_RESTRICT fractionInOut);

HK_INLINE   hkVector4Comparison hkcdRayDirectionAabbBundleIntersect(hkVector4Parameter rayInvDirection,
                                                                const hkFourTransposedPoints& aabbMin, const hkFourTransposedPoints& aabbMax,
                                                                const hkVector4& fraction);


    /// Returns a bit mask corresponding to the AABBs intersecting the ray.
    /// Test result with hkVector4ComparisonMask::MASK_X for aabb0, hkVector4ComparisonMask::MASK_Y for aabb1 and so on.
HK_INLINE int           hkcdIntersectRayBundleAabb( const hkcdRay& ray,
                                                            const hkAabb& aabb0, const hkAabb& aabb1, const hkAabb& aabb2, const hkAabb& aabb3,
                                                            const hkSimdReal& earlyOutHitFraction);

#include <Geometry/Collide/Algorithms/Intersect/hkcdIntersectRayAabb.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
