// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#include <Geometry/Collide/Algorithms/Triangle/hkcdTriangleUtil.h>


/// Tests whether the given point vP is inside the triangle (vA, vB, vC). The triangle normal is also required as input in vN.
/// On success (i.e. point in triangle), the function provides the barycentric coordinates if baryOut is not null.
HK_INLINE hkBool32 HK_CALL hkcdIntersectPointTriangle(hkVector4Parameter vP,
                                                     hkVector4Parameter vA, hkVector4Parameter vB, hkVector4Parameter vC,
                                                     hkVector4Parameter vN,
                                                     hkSimdRealParameter tolerance,
                                                     hkVector4* HK_RESTRICT baryOut = HK_NULL);

/// Tests whether the given point vP is inside the triangle (vA, vB, vC).
/// On success (i.e. point in triangle), the function provides the barycentric coordinates if baryOut is not null.
HK_INLINE hkBool32 HK_CALL hkcdIntersectPointTriangle(hkVector4Parameter vP,
                                                     hkVector4Parameter vA, hkVector4Parameter vB, hkVector4Parameter vC,
                                                     hkSimdRealParameter tolerance,
                                                     hkVector4* HK_RESTRICT baryOut = HK_NULL);

#include <Geometry/Collide/Algorithms/Intersect/hkcdIntersectPointTriangle.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
