// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Geometry/Collide/hkcdCollide.h>
#include <Geometry/Collide/Algorithms/Intersect/hkcdIntersectAabbTriangle.h>
#include <Common/Base/Math/Vector/hkVector4Util.h>

//
hkBool32 HK_CALL hkcdIntersectAabbTriangle(const hkAabb& aabb, hkVector4Parameter triA, hkVector4Parameter triB, hkVector4Parameter triC)
{
    // Check the triangle AABB against the query AABB. If there's no overlap, return false.
    
    {
        // This corresponds to checking the AABB faces as separating axes
        hkAabb triAabb;
        triAabb.setFromTriangle(triA, triB, triC);

        if( !aabb.overlaps(triAabb) )
        {
            return hkFalse32;
        }
    }

    // Recenter the AABB
    hkVector4 center; aabb.getCenter(center);
    hkVector4 ext; aabb.getHalfExtents(ext);

    hkVector4 V0; V0.setSub(triA, center);
    hkVector4 V1; V1.setSub(triB, center);
    hkVector4 V2; V2.setSub(triC, center);

    hkVector4 f0, f1, f2; // edge vectors
    f0.setSub(triB, triA);
    f1.setSub(triC, triB);
    f2.setSub(triA, triC);

    // Check cross product of AABB edges and triangle edges as separating axes
    for (int aabbAxis =0 ; aabbAxis < 3; aabbAxis++)
    {
        
        hkVector4 e = hkVector4::getConstant( hkVectorConstant(HK_QUADREAL_1000 + aabbAxis) );
        hkVector4 a0; a0.setCross( e, f0 );
        hkVector4 a1; a1.setCross( e, f1 );
        hkVector4 a2; a2.setCross( e, f2 );

        // dot a with the 3 vertices and store the results in p
        
        hkVector4 p0, p1, p2;
        hkVector4Util::dot3_1vs3(V0, a0, a1, a2, p0);
        hkVector4Util::dot3_1vs3(V1, a0, a1, a2, p1);
        hkVector4Util::dot3_1vs3(V2, a0, a1, a2, p2);

        hkVector4 pMin, pMax;
        pMin.setMin( p0, p1 ); pMin.setMin( pMin, p2 );
        pMax.setMax( p0, p1 ); pMax.setMax( pMax, p2 );

        hkVector4 abs_a0; abs_a0.setAbs(a0);
        hkVector4 abs_a1; abs_a1.setAbs(a1);
        hkVector4 abs_a2; abs_a2.setAbs(a2);

        hkVector4 r;
        hkVector4Util::dot3_1vs3(ext, abs_a0, abs_a1, abs_a2, r);

        hkVector4 negPMax; negPMax.setNeg<4>(pMax);
        hkVector4 maxOfMins; maxOfMins.setMax( negPMax, pMin );
        if ( maxOfMins.greater(r).anyIsSet(hkVector4ComparisonMask::MASK_XYZ) )
        {
            return hkFalse32;  // one of the a's is a separating axis
        }

    }

    // Finally, check triangle plane
    {
        hkVector4 normal; normal.setCross(f0, f1);
        normal.normalize<3>();
        normal.setPlaneConstant( V0 );

        // V0 is already offset by AABB center, so treat center as 0
        hkVector4 absNormal; absNormal.setAbs(normal);
        hkSimdReal r = absNormal.dot<3>(ext);
        hkSimdReal s = absNormal.getComponent<3>();
        if (s.isGreater(r))
        {
            return hkFalse32;
        }
    }

    return true;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
