// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Geometry/Collide/hkcdCollide.h>
#include <Geometry/Collide/Algorithms/FractureEngine/hkcdFractureEngine.h>
#include <Geometry/Collide/DataStructures/Planar/CSG/hkcdPlanarCsgOperand.h>
#include <Common/Base/Thread/Atomic/hkAtomicPrimitives.h>

//
//  Constructor

hkcdFractureEngine::hkcdFractureEngine()
:   hkReferencedObject()
{}

//
//  Constructor

hkcdFractureEngine::TaskDataBlock::TaskDataBlock()
:   hkReferencedObject()
,   m_writerTaskId(hkTaskGraph::TaskId::invalid())
,   m_numDependentTasks(0)
{}

//
//  Copy constructor

hkcdFractureEngine::TaskDataBlock::TaskDataBlock(const TaskDataBlock& other)
:   hkReferencedObject()
,   m_writerTaskId(hkTaskGraph::TaskId::invalid())
,   m_numDependentTasks(0)
{}

//
//  Destructor

hkcdFractureEngine::TaskDataBlock::~TaskDataBlock()
{
    // The data block is going away, make sure all the tasks that depend on it have been processed!
    HK_ASSERT_NO_MSG(0x5a466e77, m_numDependentTasks == 0);
}

//
//  Increases the numbers of tasks that depend on this data block

void hkcdFractureEngine::TaskDataBlock::addDependency()
{
    hkUint32* addr = &m_numDependentTasks;

    for (hkAtomic::Backoff<> b; ; b.pause())
    {
        const hkUint32 oldVal = *addr;
        const hkUint32 newVal = oldVal + 1;

        if ( hkAtomic::compareAndSwap<hkUint32>(addr, oldVal, newVal) )
        {
            HK_ASSERT_NO_MSG(0x441f8f24, int(newVal) > 0);
            return;
        }
    }
}

//
//  Decreases the number of tasks that depend on this data block

void hkcdFractureEngine::TaskDataBlock::removeDependency()
{
    hkUint32* addr = &m_numDependentTasks;

    for (hkAtomic::Backoff<> b; ; b.pause())
    {
        const hkUint32 oldVal = *addr;
        const hkUint32 newVal = oldVal - 1;

        if ( hkAtomic::compareAndSwap<hkUint32>(addr, oldVal, newVal) )
        {
            // Destroy the data if the block has no more dependencies
            if ( !newVal )
            {
                destroyPayload();
            }

            HK_ASSERT_NO_MSG(0x1ac2adb4, int(newVal) >= 0);

            return;
        }
    }
}

//
//  Adds the given data block as input of the current task

void hkcdFractureEngine::FractureTask::addInput(hkTaskGraph& taskGraphIn, _Inout_ TaskDataBlock* inBlock)
{
    m_inputs.expandOne() = inBlock;

    if ( inBlock->m_writerTaskId.isValid() )
    {
        taskGraphIn.addDependency(inBlock->m_writerTaskId, m_id);
    }
    inBlock->addDependency();
}

//
//  Adds the given data block as output of the current task

void hkcdFractureEngine::FractureTask::addOutput(_Inout_ TaskDataBlock* outBlock)
{
    m_outputs.expandOne() = outBlock;

    outBlock->m_writerTaskId = m_id;
    outBlock->addDependency();
}

//
//  Processes the task

void hkcdFractureEngine::FractureTask::clear()
{
    // Un-reference the inputs and outputs, we don't need them anymore
    for (int k = m_inputs.getSize() - 1; k >= 0; k--)
    {
        m_inputs[k]->removeDependency();
    }

    for (int k = m_outputs.getSize() - 1; k >= 0; k--)
    {
        TaskDataBlock* outBlock = m_outputs[k];
        if ( outBlock->m_writerTaskId == m_id )
        {
            outBlock->m_writerTaskId = hkTaskGraph::TaskId::invalid();
        }
        outBlock->removeDependency();
    }
}

//
//  Constructor

hkcdFractureEngine::FractureTask::FractureTask(hkTaskGraph& taskGraphIn)
{
    m_id = taskGraphIn.addTask(this);
}

//
//  Processes the task

void hkcdFractureEngine::FractureTask::process(const hkTask::Input&)
{
    clear();
    delete this;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
