// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE hkSimdReal hkcdDistanceRayAabbProcessor::distanceSquared(const hkAabb& aabb, hkSimdReal* HK_RESTRICT fractionInOut)
{
#if HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED

    hkAabb relAabb;
    relAabb.m_min.setSub(aabb.m_min, m_ray.m_origin);
    relAabb.m_max.setSub(aabb.m_max, m_ray.m_origin);

    hkVector4 dNearTemp;    dNearTemp.setMul(relAabb.m_min, m_ray.m_invDirection);
    hkVector4 dFarTemp;     dFarTemp.setMul(relAabb.m_max, m_ray.m_invDirection);

    hkVector4 dNear;    dNear.setMin(dNearTemp, dFarTemp);
    hkVector4 dFar;     dFar.setMax(dNearTemp, dFarTemp);

    const hkSimdReal fraction = *fractionInOut;

    hkSimdReal nearMax = dNear.horizontalMax<3>();  // nn.todo maxI
    hkSimdReal farMin = dFar.horizontalMin<3>();

    nearMax.setMax(nearMax, hkSimdReal_0);
    farMin.setMin(farMin, fraction);                // nn.todo it can clip the value, to => wrong res

    if (nearMax.isLessEqual(farMin))
    {
        *fractionInOut = nearMax;
        return hkSimdReal_0;
    }

    //if (ORTHOGONAL_AXIS_COUNT == 2)
    //{
    //  hkVector4ComparisonMask::Mask axisOrthogonal = m_ray.m_direction.equalZero().getMask();
    //  int notOrthogonalIndex = axisOrthogonal ^ hkVector4ComparisonMask::Mask::MASK_XYZ - 1;

    //  hkSimdReal tNear = dNear.getComponent(notOrthogonalIndex);
    //  hkSimdReal tFar = dFar.getComponent(notOrthogonalIndex);

    //  hkSimdReal tCloser = tNear > 0 ? tNear : tFar;
    //  hkSimdReal t = tNear * tFar > 0 ? tCloser : 0.0f;

    //  hkVector4 ptOnRay;  ptOnRay.setAddMul(m_ray.m_origin, m_ray.m_direction, t);

    //  hkVector4 ptOnAabb;

    //  hkVector4Comparison cmpMax = ptOnRay.less(aabb.m_max);
    //  ptOnAabb.setSelect(cmpMax, ptOnRay, aabb.m_max);

    //  hkVector4Comparison cmpMin = ptOnAabb.greater(aabb.m_min);
    //  ptOnAabb.setSelect(cmpMin, ptOnAabb, aabb.m_min);

    //  *fractionInOut = t;

    //  return ptOnRay.distanceToSquared3(ptOnAabb);
    //}
    //else
    {
        hkIntVector iAnd; iAnd.setAll(0xfffffff0);
        hkIntVector iOrDiff1;   iOrDiff1.set(0x1, 0x6, 0x8, 0x0);
        hkIntVector iOrDiff2;   iOrDiff2.set(0x2, 0x4, 0x9, 0x0);

        hkVector4 dFarYZX;  dFarYZX.setPermutation<hkVectorPermutation::YZXW>(dFar);
        hkVector4 dFarZXY;  dFarZXY.setPermutation<hkVectorPermutation::ZXYW>(dFar);

        hkVector4 diffYZX;  diffYZX.setSub(dNear, dFarYZX);
        hkVector4 diffZXY;  diffZXY.setSub(dNear, dFarZXY);

        diffYZX = hkIntVector::injectBitsf(diffYZX, iAnd, iOrDiff1);
        diffZXY = hkIntVector::injectBitsf(diffZXY, iAnd, iOrDiff2);

        hkVector4 testMaxDiff;  testMaxDiff.setMax(diffYZX, diffZXY);

        hkSimdReal maxDiff = testMaxDiff.horizontalMaxI<3>();

        unsigned char * c = reinterpret_cast<unsigned char*>(&maxDiff.m_real);
        int nearIndex = (0xf & *c) >> 2;
        int farIndex = 0x3 & *c;

        //if (ORTHOGONAL_AXIS_COUNT == 1)
        //{
        //  // nn.todo: this is completely out of date now
        //}

        int index = nearIndex * 3 + farIndex;
        const DistPrecalcItem& pi = m_distPrecalcTable[index];

        hkSimdReal m = dFar.getComponent(farIndex);
        hkSimdReal maxDiffSquared = maxDiff*maxDiff;

        hkSimdReal t;               t.setAddMul(m, maxDiff, hkSimdReal::fromFloat(pi.fractionRatio));
        hkSimdReal distanceSquared; distanceSquared.setMul(maxDiffSquared, hkSimdReal::fromFloat(pi.distanceSquaredRatio));

        // check for edge
        hkVector4 pt;   pt.setAddMul(m_ray.m_origin, m_ray.m_direction, t);
        hkSimdReal val = pt.getComponent(pi.otherComponent);
        if (val < aabb.m_min.getComponent(pi.otherComponent))
        {
            hkVector4 ptOnAabb1;    aabb.getVertex(pi.minSupportPoint, ptOnAabb1);
            hkVector4 ptOnAabb2;    aabb.getVertex(pi.maxSupportPoint, ptOnAabb2);

            hkVector4 ptOnAabb;     ptOnAabb.setMin(ptOnAabb1, ptOnAabb2);

            hkSimdReal delta = ptOnAabb.getComponent(pi.otherComponent) - val;
            t.setAddMul(t, pi.R, delta);

            hkVector4 ptNew;    ptNew.setAddMul(m_ray.m_origin, m_ray.m_direction, t);
            distanceSquared = ptNew.distanceToSquared(ptOnAabb);
        }
        else if (val > aabb.m_max.getComponent(pi.otherComponent))
        {
            hkVector4 ptOnAabb1;    aabb.getVertex(pi.minSupportPoint, ptOnAabb1);
            hkVector4 ptOnAabb2;    aabb.getVertex(pi.maxSupportPoint, ptOnAabb2);

            hkVector4 ptOnAabb;     ptOnAabb.setMax(ptOnAabb1, ptOnAabb2);

            hkSimdReal delta = ptOnAabb.getComponent(pi.otherComponent) - val;
            t.setAddMul(t, pi.R, delta);

            hkVector4 ptNew;    ptNew.setAddMul(m_ray.m_origin, m_ray.m_direction, t);
            distanceSquared = ptNew.distanceToSquared(ptOnAabb);
        }

        *fractionInOut = t;

        return distanceSquared;
    }
#else
    HK_ASSERT_NOT_IMPLEMENTED(0x15016cae);

    return hkSimdReal_0;
#endif
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
