// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Math/Vector/hkVector4Util.h>
#include <Common/Base/Math/Vector/hkVector4f.h>
#include <Common/Base/Math/Vector/hkIntVector.h>
#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>
#include <Geometry/Collide/Types/hkcdRay.h>

#pragma once

struct hkcdDistanceRayAabbProcessor
{
public:

    hkcdDistanceRayAabbProcessor()
    {
        m_distPrecalcTable.setSize(9);
    }

    HK_EXPORT_COMMON void init(const struct hkcdRay& ray);

    HK_INLINE hkSimdReal distanceSquared(const hkAabb& aabb, hkSimdReal* HK_RESTRICT fractionInOut);

    hkcdRay m_ray;

private:

    struct DistPrecalcItem
    {
        hkReal fractionRatio;
        hkReal distanceSquaredRatio;
        int minSupportPoint;
        int maxSupportPoint;
        hkSimdReal R;
        int otherComponent;
    };

    hkInplaceArray<DistPrecalcItem, 9> m_distPrecalcTable;

    HK_INLINE void addTableEntry(const hkAabb& box, int index, int minComponent, int maxComponent, int otherComponent);
};

#include <Geometry/Collide/Algorithms/Distance/hkcdDistanceRayAabb.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
