// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#include <Geometry/Collide/hkcdCollide.h>
#include <Geometry/Collide/Algorithms/Distance/hkcdDistanceRayAabb.h>
#include <Geometry/Collide/Algorithms/ClosestPoint/hkcdClosestPointLineLine.h>

namespace hkcdDistanceRayAabb
{
    struct SupportPoints
    {
        char min;
        char max;
    };

    static SupportPoints m_aabbSupportPoints[8][3] =
    {
        { { 6, 1 },{ 5, 2 },{ 3, 4 }, },    // 0
        { { 7, 0 },{ 4, 3 },{ 2, 5 }, },    // 1 x
        { { 4, 3 },{ 7, 0 },{ 1, 6 }, },    // 2 y
        { { 5, 2 },{ 6, 1 },{ 0, 7 }, },    // 3 xy
        { { 2, 5 },{ 1, 6 },{ 7, 0 }, },    // 4 z
        { { 3, 4 },{ 0, 7 },{ 6, 1 }, },    // 5 xz
        { { 0, 7 },{ 3, 4 },{ 5, 2 }, },    // 6 yz
        { { 1, 6 },{ 2, 5 },{ 4, 3 }, },    // 7 xyz
    };
}

HK_INLINE void hkcdDistanceRayAabbProcessor::addTableEntry(
    const hkAabb& box, int index,
    int minComponent, int maxComponent, int otherComponent)
{
    hkVector4 pt1;  box.getVertex(hkcdDistanceRayAabb::m_aabbSupportPoints[7][minComponent].min, pt1);
    hkVector4 pt2;  box.getVertex(hkcdDistanceRayAabb::m_aabbSupportPoints[7][maxComponent].max, pt2);

    hkVector4 dir;  dir.setSub(pt2, pt1);

    hkSimdReal t, u;
    hkcdClosestPointLineLine(m_ray.m_origin, m_ray.m_direction, pt1, dir, t, u);

    // t and u are always equal
    // maybe remove u calculation
    //HK_ASSERT_NO_MSG(0x42e7308e, t.equal(u).allAreSet());

    // calc distance squared
    hkVector4 ptOnRay;  ptOnRay.setAddMul(m_ray.m_origin, m_ray.m_direction, t);
    hkVector4 ptOnBox;  ptOnBox.setAddMul(pt1, dir, t);
    hkSimdReal d2 = ptOnRay.distanceToSquared(ptOnBox);

    // calc fraction change per 1m change on other line
    hkSimdReal R = dir.dot<3>(m_ray.m_direction).sqrt();

    // add entry to the table
    int tabIndex = minComponent * 3 + maxComponent;
    DistPrecalcItem& entry1 = m_distPrecalcTable[tabIndex];

    entry1.fractionRatio = t.getReal();
    entry1.distanceSquaredRatio = d2.getReal();
    entry1.minSupportPoint = hkcdDistanceRayAabb::m_aabbSupportPoints[index][minComponent].min;
    entry1.maxSupportPoint = hkcdDistanceRayAabb::m_aabbSupportPoints[index][maxComponent].max;
    entry1.otherComponent = otherComponent;
    entry1.R = R;

    // vice versa, when min and max components are replaced
    int tabIndex2 = maxComponent * 3 + minComponent;
    DistPrecalcItem& entry2 = m_distPrecalcTable[tabIndex2];

    entry2.fractionRatio = 1.0f - t.getReal();
    entry2.distanceSquaredRatio = d2.getReal();
    entry2.minSupportPoint = hkcdDistanceRayAabb::m_aabbSupportPoints[index][maxComponent].min;
    entry2.maxSupportPoint = hkcdDistanceRayAabb::m_aabbSupportPoints[index][minComponent].max;
    entry2.otherComponent = otherComponent;
    entry2.R = R;
}

void hkcdDistanceRayAabbProcessor::init(const struct hkcdRay& ray)
{
    m_ray = ray;

    // nn.todo  use greaterEqual instead
    int index = 0;
    {
        index = index | (m_ray.m_direction(0) >= 0 ? 0x0 : 0x1);
        index = index | (m_ray.m_direction(1) >= 0 ? 0x0 : 0x2);
        index = index | (m_ray.m_direction(2) >= 0 ? 0x0 : 0x4);
    }

    hkAabb box; box.setFromLine(ray.m_origin, ray.m_origin + ray.m_direction);

    addTableEntry(box, index, 0, 1, 2);
    addTableEntry(box, index, 0, 2, 1);
    addTableEntry(box, index, 1, 2, 0);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
