// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

/// Projects a point onto a convex hull spanned by the given plane equations. Terminates early if the point is further away than indicated by maxDistanceSquared.
/// NOTE: Point and planes must all be defined in the same space.
HK_INLINE bool HK_CALL hkcdDistancePointConvex::hkcdPointConvex(    hkVector4Parameter point,
                                     const hkVector4* HK_RESTRICT planes, int numPlanes, hkSimdRealParameter maxDistanceSquared,
                                     hkVector4& pointOnSurface, hkVector4& surfaceNormal, hkSimdReal& signedDistance, int& numIterationsUsed)
{
    return _hkcdPointConvex(point, planes, numPlanes, maxDistanceSquared, 100, pointOnSurface, surfaceNormal, signedDistance, numIterationsUsed);
}

/// Projects a point onto a convex hull spanned by the given plane equations.
/// NOTE: Point and planes must all be defined in the same space.
HK_INLINE bool HK_CALL hkcdDistancePointConvex::hkcdPointConvex(    hkVector4Parameter point,
                                             const hkVector4* HK_RESTRICT planes, int numPlanes,
                                             hkVector4& pointOnSurface, hkVector4& surfaceNormal, hkSimdReal& signedDistance, int& numIterationsUsed)
{
    return _hkcdPointConvex(point, planes, numPlanes, hkSimdReal::getConstant<HK_QUADREAL_MAX>(), 100, pointOnSurface, surfaceNormal, signedDistance, numIterationsUsed);
}

/// Approximately projects a point onto a convex hull spanned by the given plane equations.
/// NOTE: Point and planes must all be defined in the same space.
HK_INLINE bool HK_CALL hkcdDistancePointConvex::hkcdPointConvexApprox(  hkVector4Parameter point,
                                                const hkVector4* HK_RESTRICT planes, int numPlanes,
                                                hkVector4& pointOnSurface, hkVector4& surfaceNormal, hkSimdReal& signedDistance)
{
    int numIterationsUsed;
    return _hkcdPointConvex(point, planes, numPlanes, hkSimdReal::getConstant<HK_QUADREAL_MAX>(), 1, pointOnSurface, surfaceNormal, signedDistance, numIterationsUsed);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
