// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

//
HK_INLINE hkSimdReal hkcdAabbAabbDistanceSquared(const hkAabb& a, hkVector4Parameter center, hkVector4Parameter halfExtents)
{
    hkAabb      aabb;
    aabb.m_min.setSub(a.m_min, halfExtents);
    aabb.m_max.setAdd(a.m_max, halfExtents);

    hkVector4   projection;
    projection.setMin(aabb.m_max, center);
    projection.setMax(aabb.m_min, projection);

    return projection.distanceToSquared(center);
}

//
//  Computes the squared distance between a point and an AABB

HK_INLINE const hkSimdReal hkcdPointAaabbDistanceSquared(hkVector4Parameter vPt, const hkAabb& aabb)
{
    hkVector4 projection;
    projection.setMin(aabb.m_max, vPt);
    projection.setMax(aabb.m_min, projection);
    projection.sub(vPt);

    return projection.lengthSquared<3>();
}

//
HK_INLINE hkSimdReal hkcdAabbAabbDistanceSquared(const hkAabb& a, const hkAabb& b)
{
    hkVector4   halfExtents; b.getHalfExtents(halfExtents);
    hkVector4   center; b.getCenter(center);

    return hkcdAabbAabbDistanceSquared(a, center, halfExtents);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
