// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

/// Specialized utility used to optimize the number of faces of a convex hull.
/// Notes:
/// - Only 3D convex hulls are supported.
/// - The minimum number of faces is 6.
/// - The is a slow process, avoid using this at run-time.
class HK_EXPORT_COMMON hkcdConvexHullFaceOptimizer : public hkReferencedObject
{
    public:

    HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_GEOMETRY );

    hkcdConvexHullFaceOptimizer();
    ~hkcdConvexHullFaceOptimizer();

    void    initialize( const class hkgpConvexHull& hull );
    void    optimize( int numFaces, const hkReal maxError = hkReal( 0.001 ) );

    void    clear();
    bool    refine();

    class hkgpConvexHull*   m_hull;         ///< Current convex hull.
    hkArray<hkVector4>      m_planes;       ///< Candidate planes.
    int                     m_baseFaces;    ///< Original number of faces.
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
