// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE void hkcdClosestPointSegmentSegment(
    hkVector4_ A, hkVector4_ dA, hkVector4_ B, hkVector4_ dB,
    hkSimdReal& tOut, hkSimdReal& uOut )
{
    hkVector4 d12; d12.setSub(B,A);

    
    hkSimdReal R = dA.dot<3>(dB);
    hkSimdReal S1 = dA.dot<3>(d12);
    hkSimdReal S2 = dB.dot<3>(d12);
    const hkSimdReal dAlen2 = dA.lengthSquared<3>();
    const hkSimdReal dbLen2 = dB.lengthSquared<3>();

    // denom == 0 means lines are parallel
    // denom always >= 0 by triangle inequality
    hkSimdReal denom = dAlen2 * dbLen2 - R * R;
    //denom.setMax(denom, eps); // avoid divide by zero, not needed since we have HK_DIV_SET_ZERO

    hkSimdReal invDenom; invDenom.setReciprocal<HK_ACC_MID, HK_DIV_SET_ZERO>(denom);
    hkSimdReal invD2; invD2.setReciprocal(dbLen2);
    hkSimdReal invD1; invD1.setReciprocal(dAlen2);

    // find the closest point on infinite line A to the infinite line B
    hkSimdReal t;
    {
        t = (S1 * dbLen2 - S2 * R);
        t.mul(invDenom);
        t.setClampedZeroOne( t );
    }

    // By convention, if the segments are parallel (i.e. denom == 0 <= eps) we choose t = 1. This is how the previous version worked.
    // t.setSelect(denom.lessEqual(eps), hkSimdReal_1, t); not needed as we clamped between 0 and 1 for parallel edges

    // find the closest point on B to the point we just found
    hkSimdReal u;
    {
        u = t * (invD2*R) - (invD2*S2); // invD2 is already available earlier, multiple the factors instead of u
        u.setClampedZeroOne(u);
    }

    // if the point on B was clamped, we may need to update the point on A
    {
        t = u * (invD1*R) + (invD1*S1); // invD1 is already available earlier, multiple the factors instead of t
        t.setClampedZeroOne(t);
    }
    uOut = u;
    tOut = t;
}

HK_INLINE hkVector4Comparison hkcdClosestPointSegmentSegment(
    hkVector4_ A, hkVector4_ dA, hkVector4_ B, hkVector4_ dB,
    hkVector4& closestPointAout, hkVector4& closestAminusClosestBout, hkSimdReal& distanceSquaredOut )
{
    hkSimdReal t,u;
    hkcdClosestPointSegmentSegment(A,dA,B,dB, t,u);

    hkVector4 closestPointA; closestPointA.setAddMul( A, dA, t );
    hkVector4 closestPointB; closestPointB.setAddMul( B, dB, u );

    hkVector4 AminusB; AminusB.setSub( closestPointA, closestPointB );


    hkVector4 ttuu; ttuu.set(t,t,u,u);
    const hkVector4 c1010 = hkVector4::getConstant<HK_QUADREAL_1010>();

    closestPointAout = closestPointA;
    closestAminusClosestBout = AminusB;
    distanceSquaredOut = AminusB.lengthSquared<3>();

    return ttuu.equal(c1010);
}

HK_INLINE void hkcdClosestPointSegment4Segments(
    hkVector4_ A, hkVector4_ dA,
    hkVector4_ B0, hkVector4_ dB0,
    hkVector4_ B1, hkVector4_ dB1,
    hkVector4_ B2, hkVector4_ dB2,
    hkVector4_ B3, hkVector4_ dB3,
    hkVector4& tOut, hkVector4& uOut )
{
    hkVector4 dAB0; dAB0.setSub(B0,A);
    hkVector4 dAB1; dAB1.setSub(B1,A);
    hkVector4 dAB2; dAB2.setSub(B2,A);
    hkVector4 dAB3; dAB3.setSub(B3,A);

    
    hkVector4 R;  hkVector4Util::dot3_1vs4( dA, dB0, dB1, dB2, dB3, R );
    hkVector4 S1; hkVector4Util::dot3_1vs4( dA, dAB0, dAB1, dAB2, dAB3, S1 );
    hkVector4 S2; hkVector4Util::dot3_4vs4( dB0, dAB0, dB1, dAB1, dB2, dAB2, dB3, dAB3, S2 );

    const hkSimdReal dAlen2 = dA.lengthSquared<3>();
    hkVector4 dbLen2; hkVector4Util::dot3_4vs4( dB0,dB0, dB1, dB1, dB2, dB2, dB3, dB3, dbLen2);

    hkVector4 eps; eps.setAll(hkSimdReal_Eps);

    // denom == 0 means lines are parallel
    // denom always >= 0 by triangle inequality
    hkVector4 denom = dbLen2*dAlen2 - R * R;
    denom.setMax(denom, eps); // avoid divide by zero

    hkVector4   invDenom; invDenom.setReciprocal(denom);
    hkVector4   invD2;    invD2.setReciprocal(dbLen2);
    hkSimdReal invD1;    invD1.setReciprocal(dAlen2);

    // find the closest point on infinite line A to the infinite line B
    hkVector4 t;
    {
        t = (S1 * dbLen2 - S2 * R);
        t.setClamped(t, hkVec4_0, denom);
        t.mul( invDenom ); // use invDenom as late as possible
    }

    // By convention, if the segments are parallel (i.e. denom == 0 <= eps) we choose t = 1. This is how the previous version worked.
    t.setSelect(denom.lessEqual(eps), hkVec4_1, t);

    // find the closest point on B to the point we just found
    hkVector4 u;
    {
        u = t * (invD2*R) - (invD2*S2); // invD2 is already available earlier, multiple the factors instead of u
        u.setClampedZeroOne(u);
    }

    // if the point on B was clamped, we may need to update the point on A
    {
        t = u * (R*invD1) + (S1*invD1); // invD1 is already available earlier, multiple the factors instead of t
        t.setClampedZeroOne(t);
    }
    uOut = u;
    tOut = t;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
