// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#include <Common/Base/Math/Vector/hkVector4Util.h>

/// Computes the closest points pair between two line segments and as segment fractions t,u of the inputs.
/// Each segment is given by its starting point and its direction.
/// The closest point on the first line is A+tOut*dA and the closest point on the second line is B+uOut*dB.
/// You can check if the closest point is an endpoint by comparing the t and u values against 0 and 1.
HK_INLINE void hkcdClosestPointSegmentSegment(
    hkVector4_ A, hkVector4_ dA, hkVector4_ B, hkVector4_ dB,
    hkSimdReal& tOut, hkSimdReal& uOut );

/// Compute and return the closest points and distance between two segments.
/// The return value contains is a mask indicating which endpoints, if any, of the line
/// are not part of the closest distance. MASK_X and MASK_Y correspond to the start and end point
/// of the first segment respectively. Similarly MASK_Z and MASK_W correspond to the start and end
/// of the second segment.
HK_INLINE hkVector4Comparison hkcdClosestPointSegmentSegment(
    hkVector4_ A, hkVector4_ dA, hkVector4_ B, hkVector4_ dB,
    hkVector4& closestPointB, hkVector4& closestAminusClosestB, hkSimdReal& squareDistanceOut );

/// Computes the closest points pair between a line segments and three other segments and outputs fractions t,u of the inputs.
HK_INLINE void hkcdClosestPointSegment4Segments(
    hkVector4_ A, hkVector4_ dA,
    hkVector4_ B0, hkVector4_ dB0,
    hkVector4_ B1, hkVector4_ dB1,
    hkVector4_ B2, hkVector4_ dB2,
    hkVector4& tOut, hkVector4& uOut );

#include <Geometry/Collide/Algorithms/ClosestPoint/hkcdClosestPointSegmentSegment.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
