// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#include <Common/Base/Math/Vector/hkFourTransposedPoints.h>

    /// Computes the closest points pair between two infinite lines and returns the parameters t,u of the closest point.
    /// If the lines are parallel, false is returned and t is arbitrarily set to 1.
    /// Each line is given by its starting point and its direction.
    /// The closest point on the first line is A+tOut*dA and the closest point on the second line is B+uOut*dB.
HK_INLINE hkBool32 hkcdClosestPointLineLine(
    hkVector4Parameter A, hkVector4Parameter dA, hkVector4Parameter B, hkVector4Parameter dB,
    hkSimdReal& tOut, hkSimdReal& uOut );

    /// Batch version of infinite line closest check.
HK_INLINE void hkcdClosestPointLineLine(
    const hkFourTransposedPoints& A, const hkFourTransposedPoints& dA, hkVector4Parameter B, hkVector4Parameter dB,
    hkVector4& tOut, hkVector4& uOut );

#include <Geometry/Collide/Algorithms/ClosestPoint/hkcdClosestPointLineLine.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
