// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// This is a precompiled header
#define _CRT_SECURE_NO_WARNINGS 1

// Maya includes
#include <ContentTools/Maya/MayaSceneExport/hctMayaIncludes.h>

// Havok includes
#include <Common/Base/hkBase.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>

#include <ContentTools/Common/SceneExport/hctSceneExport.h> // includes windows
#include <ContentTools/Common/SceneExport/Filters/hctFilterProcessingUtil.h>
#include <ContentTools/Common/SceneExport/AttributeProcessing/hctAttributeProcessingUtil.h>
#include <ContentTools/Common/SceneExport/AttributeSelection/hctAttributeSelectionUtil.h>
#include <ContentTools/Common/SceneExport/Utils/hctSceneExportUtils.h>
#include <Common/SceneData/Scene/hkxScene.h>
#include <Common/SceneData/Graph/hkxNode.h>
#include <Common/SceneData/Selection/hkxNodeSelectionSet.h>
#include <Common/SceneData/Light/hkxLight.h>
#include <Common/SceneData/Camera/hkxCamera.h>
#include <Common/SceneData/Attributes/hkxAttributeGroup.h>
#include <Common/SceneData/Mesh/hkxVertexDescription.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>

// Utilities
#include <ContentTools/Maya/MayaSceneExport/hctMayaNodeIds.h>
#include <ContentTools/Maya/MayaSceneExport/Utilities/hctMayaSceneExportUtilities.h>

// Math
#include <math.h>
#include <float.h>
#include <minmax.h>
#define PI 3.14159265358979f

#ifdef HAVOK_VISION_EXPORTER
// Vision
#include <ContentTools/Common/Vision/hctVisionCommon.h> 
#include <ContentTools/Common/Vision/ExportHelpers/hctVisionExportHelpers.h> 
#include <Vision/Runtime/Base/Math/Matrix/hkvMat4.h> 

#endif

// Node declaration macro - provides basic functions required for any node
#define HK_DECLARE_MAYA_NODE( CLASS, MAYA_NAME, MAYA_ID )   \
    static void* creator() { return new CLASS(); }          \
    static const MString typeName() { return MAYA_NAME; }   \
    static const MTypeId typeId() { return MAYA_ID; }

// Warning and error message macros
extern int isError( const MStatus& status, const MString& err, const char* file, int line);



#define RETURN_STATUS_IF_FAIL(status, err)              \
    if( isError(status, err, __FILE__, __LINE__) != 0 ) \
{                                                   \
    return status;                                  \
} else

#define WARN_IF_FAIL(status, err)               \
    if( ! status )                              \
{                                           \
    MGlobal::displayError( err );           \
} else

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
