// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Maya/MayaSceneExport/hctMayaSceneExport.h> // PCH

#include <ContentTools/Maya/MayaSceneExport/Nodes/hctMayaFilterSetOptions.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/hctMayaOptions.h>

#include <ContentTools/Maya/MayaSceneExport/Commands/ExportScene/hctCmdExportScene.h>
#include <ContentTools/Maya/MayaSceneExport/Commands/ImportScene/hctCmdImportScene.h>
#include <ContentTools/Maya/MayaSceneExport/Commands/GetVersion/hctCmdGetVersion.h>
#include <ContentTools/Maya/MayaSceneExport/Utilities/hctMayaUtilities.h>

// SDK utils
#include <ContentTools/Common/SceneExport/Memory/hctSceneExportMemory.h>



// Nodes
#include <ContentTools/Maya/MayaSceneExport/Nodes/Decomposition/hctDecompositionNode.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/Capsule/hctCapsuleNode.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/RigidBody/hctRigidBodyNode.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/Shape/hctShapeNode.h>

#include <ContentTools/Maya/MayaSceneExport/Nodes/Constraints/BallAndSocket/hctBallAndSocketConstraintNode.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/Constraints/StiffSpring/hctStiffSpringConstraintNode.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/Constraints/Hinge/hctHingeConstraintNode.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/Constraints/Ragdoll/hctRagDollConstraintNode.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/Constraints/Prismatic/hctPrismaticConstraintNode.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/Constraints/Wheel/hctWheelConstraintNode.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/Constraints/Fixed/hctFixedConstraintNode.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/Generic/hctGenericNode.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/Channel/hctChannelNode.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/Cloth/hctClothCollidableNode.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/LocalFrame/hctLocalFrameNode.h>

// Commands
#include <ContentTools/Maya/MayaSceneExport/Commands/CreateConvexHull/hctCmdCreateConvexHull.h>
#include <ContentTools/Maya/MayaSceneExport/Commands/CollideGeometryOptimizer/hctCmdCgo.h>
#include <ContentTools/Maya/MayaSceneExport/Commands/ExecuteDestruction/hctCmdExecuteDestruction.h>
#include <ContentTools/Maya/MayaSceneExport/Commands/CreateConvexDecomposition/hctCmdCreateConvexDecomposition.h>
#include <ContentTools/Maya/MayaSceneExport/Commands/OpenHelp/hctCmdOpenHelp.h>
#include <ContentTools/Maya/MayaSceneExport/Commands/CreateBonesFromMesh/hctCmdCreateBonesFromMesh.h>

#include <ContentTools/Maya/MayaSceneExport/Commands/ReflectionUtilities/hctCmdGetMatchingClasses.h>
#include <ContentTools/Maya/MayaSceneExport/Commands/ReflectionUtilities/hctCmdGetDerivedClassesInfo.h>
#include <ContentTools/Maya/MayaSceneExport/Commands/ReflectionUtilities/hctCmdIsDestructionEnabled.h>
#include <ContentTools/Maya/MayaSceneExport/Commands/ReflectionUtilities/hctCmdGetLinkType.h>
#include <ContentTools/Maya/MayaSceneExport/Commands/ReflectionUtilities/hctCmdOpenChmDocs.h>

#include <ContentTools/Maya/MayaSceneExport/Utilities/hctDestructionUtilities.h>
// Context
#include <ContentTools/Maya/MayaSceneExport/Utilities/hctContext.h>

#define HK_EXCLUDE_FEATURE_DestructionRuntime
#define HK_EXCLUDE_FEATURE_hkndAssetProcessing
#define HK_EXCLUDE_FEATURE_hkndDebrisFracture_execute
#define HK_EXCLUDE_FEATURE_hkndParticleEffectFracture_execute
#define HK_EXCLUDE_FEATURE_NewDestructionRuntime
#include <Common/Base/KeyCode.h>
#undef HAVOK_PHYSICS_2012_KEYCODE
#undef HAVOK_PHYSICS_KEYCODE
#undef HK_FEATURE_PRODUCT_PHYSICS
#undef HK_FEATURE_PRODUCT_PHYSICS_2012
#undef HK_FEATURE_PRODUCT_DESTRUCTION
#undef HK_FEATURE_PRODUCT_DESTRUCTION_2012
#undef HK_FEATURE_PRODUCT_FX
// Need to register patches for Cloth Setup Tool
//#undef HK_FEATURE_PRODUCT_CLOTH
#undef HK_FEATURE_PRODUCT_BEHAVIOR
#undef HK_FEATURE_PRODUCT_ANIMATION
#undef HK_FEATURE_PRODUCT_AI
#define HK_CLASSES_FILE <Common/Base/ClassLists/hkCommonClassLists.cxx>
#define HK_EXCLUDE_FEATURE_MemoryTracker
#define HK_EXCLUDE_FEATURE_hkFormatYamlFile
#include <Common/Base/Config/hkProductFeatures.cxx>

#if defined(_DEBUG) && defined(_MSC_VER) && (_MSC_VER >= 1400)
#   undef _DEBUG
#   define HK_RESET_DEBUG_FLAG
#endif

// List of registered nodes
#include <vector>
static std::vector<MTypeId> g_registeredNodes;

// Error message helper
int isError( const MStatus& status, const MString& err, const char* file, int line)
{
  if ( status.error() )
  {
    MString e = "[hkPlugin]:";
    e += file;
    e += ":";
    e += line;
    e += ":";
    e += err;
    MGlobal::displayError(e + " " + status.errorString());
    return 1;
  }
  return 0;
}

// Command registration macro
#define REGISTER_COMMAND(COM) \
  status = plugin.registerCommand( "hkCmd" ## #COM, hctCommand##COM##::creator, hctCommand##COM##::newSyntax); \
  RETURN_STATUS_IF_FAIL(status, "registerCommand " ## #COM ## " failed")

#ifdef HK_RESET_DEBUG_FLAG
#   define _DEBUG
#   undef HK_RESET_DEBUG_FLAG
#endif


// Node initialization macro
#define HK_REGISTER_NODE( CLASS, NODE_TYPE )                                    \
  status = plugin.registerNode( CLASS::typeName(), CLASS::typeId(),         \
  &CLASS::creator, &CLASS::initialize, MPxNode::NODE_TYPE );                \
  if( status == MStatus::kSuccess ) g_registeredNodes.push_back( CLASS::typeId() ); \
  else                                                                      \
{                                                                           \
  status.perror( "Registration of 'CLASS' node failed" );                   \
  return status;                                                            \
}


bool isVisionEnabled()
{
#ifndef HAVOK_VISION_EXPORTER
  return false;
#else
  //[EXP-2413] See if the special envvar is set. If set, disable.
  char* value = getenv("HAVOK_MAYA_DISABLE_VISION");
  return value == HK_NULL;
#endif
}

#ifdef HAVOK_VISION_EXPORTER

#include <ContentTools/Maya/MayaSceneExport/Commands/Vision/hctCmdVision.h>
#include <ContentTools/Maya/MayaSceneExport/FileTranslators/Vision/hctFileTranslatorVision.h>

template<class FT>
void* CreatePlugin()
{
  //// This will end up in the BSS segment, so it will be unmapped, correctly, when unloading
  //// the .dll - the filetranslators don't contain complicated stuff, or do allocations, anyways.
  //static FT ft;
  //return &ft;
  return new FT();  // @@@ Maya does a delete in deregisterFileTranslator - allocator mismatch?
}


static void registerVisionPlugins(MFnPlugin& plugin)
{
  if (!isVisionEnabled())
    return;

  VFileAccessManager::Init();
  plugin.registerCommand       ("VisionFileTranslatorCreateGUI",                                                      &CreatePlugin<VPxCommand_FileTranslatorOptions_CreateGUI>);
  plugin.registerCommand       ("VisionFileTranslatorQueryGUI",                                                       &CreatePlugin<VPxCommand_FileTranslatorOptions_QueryGUI>);
  plugin.registerCommand       ("VisionFileTranslatorCreateAnimationGUI",                                             &CreatePlugin<VPxCommand_FileTranslatorOptions_CreateAnimationGUI>);
  //@@@remove plugin.registerCommand       ("VisionFileTranslatorOptionScript",                                                   &CreatePlugin<VPxCommand_FileTranslatorOptions>);
  plugin.registerCommand       ("VisionFileTranslatorOptionScript_Mesh",                                              &CreatePlugin<VPxCommand_FileTranslatorOptions<VGVisionImporterExporter::VDF_MESH           > >);
  plugin.registerCommand       ("VisionFileTranslatorOptionScript_Model",                                             &CreatePlugin<VPxCommand_FileTranslatorOptions<VGVisionImporterExporter::VDF_MODEL          > >);
  plugin.registerCommand       ("VisionFileTranslatorOptionScript_ColMesh",                                           &CreatePlugin<VPxCommand_FileTranslatorOptions<VGVisionImporterExporter::VDF_COLLISION_MESH > >);
  plugin.registerCommand       ("VisionFileTranslatorOptionScript_Animation",                                         &CreatePlugin<VPxCommand_FileTranslatorOptions<VGVisionImporterExporter::VDF_ANIM           > >);
  plugin.registerCommand       ("VisionFileTranslatorOptionScript_Prefab",                                            &CreatePlugin<VPxCommand_FileTranslatorOptions<VGVisionImporterExporter::VDF_PREFAB         > >);
  plugin.registerCommand       ("VisionFileTranslatorOptionScript_VisInfo",                                           &CreatePlugin<VPxCommand_FileTranslatorOptions<VGVisionImporterExporter::VDF_VISIBILITY_INFO> >);
  plugin.registerCommand       ("VisionProject",                                                                      &CreatePlugin<VPxCommand_PrefabAutoExportEditorOptions_HandleVisionProject>);
  plugin.registerCommand       ("VisionAutoExport",                                                                   &CreatePlugin<VPxCommand_PrefabAutoExportEditorOptions_HandleVisionAutoExport>);
  plugin.registerCommand       ("VisionExport",                                                                       &CreatePlugin<VPxCommand_FileTranslator_HandleVisionExport>);
  plugin.registerFileTranslator("Vision "/*VISION_RESOURCE_VERSION_PRETTY_PRINT" "*/"Static Mesh",            "none", &CreatePlugin<VPxFileTranslator<VGVisionImporterExporter::VDF_MESH,            true,         true,  true> >, "VisionFileTranslatorOptionScript_Mesh",        NULL, true/*@@@ check at the end if we can set this to false*/);
  plugin.registerFileTranslator("Vision "/*VISION_RESOURCE_VERSION_PRETTY_PRINT" "*/"Model",                  "none", &CreatePlugin<VPxFileTranslator<VGVisionImporterExporter::VDF_MODEL,           true, /*@@@*/false,  true> >, "VisionFileTranslatorOptionScript_Model",       NULL, true/*@@@ check at the end if we can set this to false*/);
  plugin.registerFileTranslator("Vision "/*VISION_RESOURCE_VERSION_PRETTY_PRINT" "*/"Collision Mesh",         "none", &CreatePlugin<VPxFileTranslator<VGVisionImporterExporter::VDF_COLLISION_MESH,  true, /*@@@*/false,  true> >, "VisionFileTranslatorOptionScript_ColMesh",     NULL, true/*@@@ check at the end if we can set this to false*/);
  plugin.registerFileTranslator("Vision "/*VISION_RESOURCE_VERSION_PRETTY_PRINT" "*/"Animation",              "none", &CreatePlugin<VPxFileTranslator<VGVisionImporterExporter::VDF_ANIM,            true, /*@@@*/false, false> >, "VisionFileTranslatorOptionScript_Animation",   NULL, true/*@@@ check at the end if we can set this to false*/);
  plugin.registerFileTranslator("Vision "/*VISION_RESOURCE_VERSION_PRETTY_PRINT" "*/"Prefab",                 "none", &CreatePlugin<VPxFileTranslator<VGVisionImporterExporter::VDF_PREFAB,          true, /*@@@*/false,  true> >, "VisionFileTranslatorOptionScript_Prefab",      NULL, true/*@@@ check at the end if we can set this to false*/);
  //plugin.registerFileTranslator("Vision "/*VISION_RESOURCE_VERSION_PRETTY_PRINT" "*/"Visibility Information", "none", &CreatePlugin<VPxFileTranslator<VGVisionImporterExporter::VDF_VISIBILITY_INFO, true, /*@@@*/false, false> >, "VisionFileTranslatorOptionScript_VisInfo",     NULL, true/*@@@ check at the end if we can set this to false*/); Disallow manual export of visibility info files.

  //plugin.registerCommand("VisionNodeProperties", &nodeProperties::creator);
  //plugin.registerCommand("VisionPrefab", &PrefabShapeCommand::creator);
}

static void deregisterVisionPlugins(MFnPlugin& plugin)
{
  if (!isVisionEnabled())
    return;

  plugin.deregisterCommand       ("VisionFileTranslatorCreateGUI");
  plugin.deregisterCommand       ("VisionFileTranslatorQueryGUI");
  plugin.deregisterCommand       ("VisionFileTranslatorCreateAnimationGUI");
  //plugin.deregisterCommand       ("VisionFileTranslatorOptionScript");
  plugin.deregisterCommand       ("VisionFileTranslatorOptionScript_Mesh");
  plugin.deregisterCommand       ("VisionFileTranslatorOptionScript_Model");
  plugin.deregisterCommand       ("VisionFileTranslatorOptionScript_ColMesh");
  plugin.deregisterCommand       ("VisionFileTranslatorOptionScript_Animation");
  plugin.deregisterCommand       ("VisionFileTranslatorOptionScript_Prefab");
  plugin.deregisterCommand       ("VisionFileTranslatorOptionScript_Material");
  plugin.deregisterCommand       ("VisionFileTranslatorOptionScript_MaterialLib");
  plugin.deregisterCommand       ("VisionFileTranslatorOptionScript_VisInfo");
  plugin.deregisterCommand       ("VisionProject");
  plugin.deregisterCommand       ("VisionAutoExport");
  plugin.deregisterCommand       ("VisionExport");
  plugin.deregisterFileTranslator("Vision "/*VISION_RESOURCE_VERSION_PRETTY_PRINT" "*/"Static Mesh");
  plugin.deregisterFileTranslator("Vision "/*VISION_RESOURCE_VERSION_PRETTY_PRINT" "*/"Model");
  plugin.deregisterFileTranslator("Vision "/*VISION_RESOURCE_VERSION_PRETTY_PRINT" "*/"Collision Mesh");
  plugin.deregisterFileTranslator("Vision "/*VISION_RESOURCE_VERSION_PRETTY_PRINT" "*/"Animation");
  plugin.deregisterFileTranslator("Vision "/*VISION_RESOURCE_VERSION_PRETTY_PRINT" "*/"Prefab");
  plugin.deregisterFileTranslator("Vision "/*VISION_RESOURCE_VERSION_PRETTY_PRINT" "*/"Material");
  plugin.deregisterFileTranslator("Vision "/*VISION_RESOURCE_VERSION_PRETTY_PRINT" "*/"Material Library");
  //plugin.deregisterFileTranslator("Vision "/*VISION_RESOURCE_VERSION_PRETTY_PRINT" "*/"Visibility Information");  Disallow manual export of visibility info files.

  //plugin.deregisterCommand("VisionNodeProperties");
  //plugin.deregisterCommand("VisionPrefab");
}

#endif


#ifdef NT_PLUGIN
__declspec( dllexport )
#endif
MStatus initializePlugin( MObject obj )
{
  // Initialize Havok memory
  hkSceneExportMemory::baseSystemInit();

  // Store the plugin object.
  hctMayaPhysicsDestructionUtilities::m_pluginObject = obj;

  MStatus status = MStatus::kSuccess;

  // Set plugin properties
  MFnPlugin plugin( obj, "Havok - Scene Exporter", HCT_CURRENT_VERSION_STRING );

  {
    MString filterPath;
    if (hctMayaUtilities::getFilterManagerPath(plugin.loadPath().asChar(), filterPath))
    {
      hkStringBuf compatPath;
      compatPath.printf("%s\\utils", filterPath.asChar());
      if (!hkCompatFormats::getInstance().isLoaded())
      {
          hkCompatFormats::replaceInstance(new hkCompatFormats(compatPath.cString()));
      }
    }
  }

  g_registeredNodes.reserve(32);

  // Register the basic nodes
  HK_REGISTER_NODE( hctDecompositionNode, kDependNode );
  HK_REGISTER_NODE( hctCapsuleNode, kDependNode );

  // Register the locator nodes and manipulators
  HK_REGISTER_NODE( hctShapeNode, kLocatorNode );
  HK_REGISTER_NODE( hctRigidBodyNode, kLocatorNode );
  HK_REGISTER_NODE( hctRigidBodyManip, kManipContainer );
  HK_REGISTER_NODE( hctBallAndSocketConstraintNode, kLocatorNode );
  HK_REGISTER_NODE( hctBallAndSocketConstraintManip, kManipContainer );
  HK_REGISTER_NODE( hctStiffSpringConstraintNode, kLocatorNode );
  HK_REGISTER_NODE( hctStiffSpringConstraintManip, kManipContainer );
  HK_REGISTER_NODE( hctHingeConstraintNode, kLocatorNode );
  HK_REGISTER_NODE( hctHingeConstraintManip, kManipContainer );
  HK_REGISTER_NODE( hctRagDollConstraintNode, kLocatorNode );
  HK_REGISTER_NODE( hctRagDollConstraintManip, kManipContainer );
  HK_REGISTER_NODE( hctPrismaticConstraintNode, kLocatorNode );
  HK_REGISTER_NODE( hctPrismaticConstraintManip, kManipContainer );
  HK_REGISTER_NODE( hctWheelConstraintNode, kLocatorNode );
  HK_REGISTER_NODE( hctWheelConstraintManip, kManipContainer );
  HK_REGISTER_NODE( hctFixedConstraintNode, kLocatorNode );
  HK_REGISTER_NODE( hctFixedConstraintManip, kManipContainer );
  HK_REGISTER_NODE( hctClothCollidableNode, kLocatorNode );
  HK_REGISTER_NODE( hctChannelNode, kLocatorNode );
  HK_REGISTER_NODE( hctLocalFrameNode, kLocatorNode );

  hctMayaPhysicsDestructionUtilities::initializeDestructionPlugin(plugin, status);

  // Register the tool context command
  status = plugin.registerContextCommand( "havokPhysicsCtx", &hctContextCommand::creator );
  if( status != MStatus::kSuccess )
  {
    status.perror( "Context command registration" );
    return status;
  }

  // Register the create convex hull command
  status = plugin.registerCommand("hkCmdCreateConvexHull", hctCmdCreateConvexHull::creator, hctCmdCreateConvexHull::getCommandSyntax );
  if( status != MStatus::kSuccess )
  {
    status.perror( "hkCmdCreateConvexHull command registration" );
    return status;
  }

  // Register the create CGO command
  status = plugin.registerCommand("hkCmdCgo", hctCmdCgo::creator, hctCmdCgo::getCommandSyntax );
  if( status != MS::kSuccess )
  {
    status.perror( "hkCmdCgo command registration" );
    return status;
  }

  // Register the convex decomposition command
  status = plugin.registerCommand( "hkCmdCreateConvexDecomposition", hctCmdCreateConvexDecomposition::creator, hctCmdCreateConvexDecomposition::getCommandSyntax );
  if( status != MStatus::kSuccess )
  {
    status.perror( "hkCmdCreateConvexDecomposition command registration" );
    return status;
  }

  status = plugin.registerCommand("hkCmdExecuteDestruction", hctCmdExecuteDestruction::creator, hctCmdExecuteDestruction::getCommandSyntax );
  if( status != MStatus::kSuccess )
  {
    status.perror( "hctCmdExecuteDestruction command registration" );
    return status;
  }

  // Register the create convex hull command
  status = plugin.registerCommand("hkCmdCreateBonesFromMesh", hctCmdCreateBonesFromMesh::creator, hctCmdCreateBonesFromMesh::getCommandSyntax );
  if( status != MStatus::kSuccess )
  {
    status.perror( "hkCmdCreateBonesFromMesh command registration" );
    return status;
  }

  // Register the commands used with reflection
  REGISTER_COMMAND(GetMatchingClasses);
  REGISTER_COMMAND(GetDerivedClassesInfo);
  REGISTER_COMMAND(IsDestructionEnabled);
  REGISTER_COMMAND(GetLinkType);
  REGISTER_COMMAND(OpenChmDocs);

  // Set the MEL procs to be run when the plugin is loaded / unloaded
  /*status = plugin.registerUI( "hctPhysics_Initialize", "hctPhysics_Deinitialize" );
  if( status != MStatus::kSuccess )
  {
    status.perror( "MEL script registration" );
    return status;
  }*/

  // Register the options node, which stores a bunch of
  // options as dynamic attributes
  status = plugin.registerNode( "hkNodeOptions",
                  hkNodeOptionsID,
                  &hctMayaOptions::creator,
                  &hctMayaOptions::initialize );
  if( status != MStatus::kSuccess )
  {
    status.perror( "hkNodeOptions node registration" );
    return status;
  }

  // Register the legacy filter set options node,
  // only so that we can convert from old scenes which use it
  status = plugin.registerNode( "hkMayaFilterSetOptions",
                  hkFilterSetOptionsID,
                  &hctMayaFilterSetOptions::creator,
                  &hctMayaFilterSetOptions::initialize );
  if( status != MStatus::kSuccess )
  {
    status.perror( "hkMayaFilterSetOptions node registration" );
    return status;
  }

  // Register the export command
  status = plugin.registerCommand("hkCmdExportScene",
                  hctCmdExportScene::creator,
                  hctCmdExportScene::getCommandSyntax );
  if( status != MStatus::kSuccess )
  {
    status.perror( "hkCmdExportScene command registration" );
    return status;
  }

  status = plugin.registerCommand("hkCmdWaitForFilterLoad",
    hctCmdWaitForFilterLoad::creator,
    hctCmdWaitForFilterLoad::getCommandSyntax );
  if( status != MStatus::kSuccess )
  {
    status.perror( "hctCmdWaitForFilterLoad command registration" );
    return status;
  }

  // Register the export command
  status = plugin.registerCommand("hkCmdGetFileDependencies",
      hctCmdGetFileDependencies::creator,
      hctCmdGetFileDependencies::getCommandSyntax);
  if (status != MStatus::kSuccess)
  {
      status.perror("hkCmdGetFileDependencies command registration");
      return status;
  }

  // Register the export command
  status = plugin.registerCommand("hkCmdImportScene",
    hctCmdImportScene::creator,
    hctCmdImportScene::getCommandSyntax );

  if( status != MStatus::kSuccess )
  {
    status.perror( "hkCmdImportScene command registration" );
    return status;
  }

  // Register the get version command
  status = plugin.registerCommand("hkCmdGetVersion",
                  hctCmdGetVersion::creator,
                  hctCmdGetVersion::getCommandSyntax );
  if( status != MStatus::kSuccess )
  {
    status.perror( "hkCmdGetVersion command registration" );
    return status;
  }

  // Register the export command
  status = plugin.registerCommand("hkCmdOpenVideoBrowser",
                  hctCmdOpenVideoBrowser::creator,
                  hctCmdOpenVideoBrowser::getCommandSyntax );
  if( status != MStatus::kSuccess )
  {
    status.perror( "hkCmdOpenVideoBrowser command registration" );
    return status;
  }

  // Register the export command
  status = plugin.registerCommand("hkCmdOpenContentToolsChm",
                  hctCmdOpenContentToolsChm::creator,
                  hctCmdOpenContentToolsChm::getCommandSyntax );
  if( status != MStatus::kSuccess )
  {
    status.perror( "hkCmdOpenContentToolsDocumentation command registration" );
    return status;
  }

  // Set the MEL procs to be run when the plugin is loaded / unloaded
  if (isVisionEnabled())
    status = plugin.registerUI( "hctExporter_Initialize", "hctExporter_Deinitialize" );
  else
    status = plugin.registerUI( "hctExporter_Initialize_NoVision", "hctExporter_Deinitialize" );

  if( status != MStatus::kSuccess )
  {
    status.perror( "MEL script registration" );
    return status;
  }

#ifdef HAVOK_VISION_EXPORTER

  registerVisionPlugins(plugin);

#endif

  // Store the plugin object with the exporter class
  hctCmdExportScene::m_pluginObject = obj;
  hctCmdGetFileDependencies::m_pluginObject = obj;
  hctCmdImportScene::m_pluginObject = obj;

  {
    MString filterPath;
    if ( hctMayaUtilities::getFilterManagerPath( plugin.loadPath().asChar(), filterPath ) )
    {
      hctFilterProcessingUtil::startBackgroundFilterLoad(filterPath.asChar());
    }
  }

  // Register upgrade callbacks
  hctShapeNode::registerCallbacks();
  hctCmdExecuteDestruction::m_pluginObject = obj;

  return status;
}

#define DEREGISTER_COMMAND(COM) \
  status = plugin.deregisterCommand( "hkCmd" ## #COM); \
  RETURN_STATUS_IF_FAIL(status, "deregisterCommand " ## #COM ## " failed")


#ifdef NT_PLUGIN
__declspec( dllexport )
#endif
MStatus uninitializePlugin( MObject obj )
{
  MStatus status;
  MFnPlugin plugin( obj );

  // Unregister upgrade callbacks
  hctShapeNode::unregisterCallbacks();

#ifdef HAVOK_VISION_EXPORTER

  deregisterVisionPlugins(plugin);

#endif

  DEREGISTER_COMMAND(OpenChmDocs);
  DEREGISTER_COMMAND(GetLinkType);
  DEREGISTER_COMMAND(IsDestructionEnabled);
  DEREGISTER_COMMAND(GetMatchingClasses);
  DEREGISTER_COMMAND(GetDerivedClassesInfo);

  std::vector<MTypeId>::iterator it;
  // Deregistration of commands
  {
    status = plugin.deregisterContextCommand( "havokPhysicsCtx" );
    if( status != MStatus::kSuccess )
    {
      status.perror( "Deregistration of havokPhysicsCtx command failed" );
      goto baseQuit;
    }

    status = plugin.deregisterCommand( "hkCmdCreateConvexHull" );
    if( status != MStatus::kSuccess )
    {
      status.perror( "Deregistration of hctCmdCreateConvexHull command failed" );
      goto baseQuit;
    }

    status = plugin.deregisterCommand( "hkCmdCgo" );
    if( status != MS::kSuccess )
    {
      status.perror( "Deregistration of hkCmdCgo command failed" );
      goto baseQuit;
    }

    status = plugin.deregisterCommand( "hkCmdCreateConvexDecomposition" );
    if( status != MStatus::kSuccess )
    {
      status.perror( "Deregistration of hctCmdCreateConvexDecomposition command failed" );
      goto baseQuit;
    }

    status = plugin.deregisterCommand( "hkCmdExecuteDestruction" );
    if( status != MStatus::kSuccess )
    {
      status.perror( "Deregistration of hkCmdExecuteDestruction command failed" );
      goto baseQuit;
    }

    status = plugin.deregisterCommand( "hkCmdCreateBonesFromMesh" );
    if( status != MStatus::kSuccess )
    {
      status.perror( "Deregistration of hkCmdCreateBonesFromMesh command failed" );
      goto baseQuit;
    }

    status = plugin.deregisterCommand( "hkCmdOpenContentToolsChm" );
    if( status != MStatus::kSuccess )
    {
      status.perror( "Deregistration of hkCmdOpenContentToolsChm command failed" );
      goto baseQuit;
    }

    status = plugin.deregisterCommand( "hkCmdOpenVideoBrowser" );
    if( status != MStatus::kSuccess )
    {
      status.perror( "Deregistration of hkCmdOpenVideoBrowser command failed" );
      goto baseQuit;
    }
  }

  // Shutdown destruction plugin
  hctMayaPhysicsDestructionUtilities::shutdownDestructionPlugin(plugin, status);

  // Deregister any nodes that were registered
  it = g_registeredNodes.begin();
  for( ; it != g_registeredNodes.end(); ++it )
  {
    status = plugin.deregisterNode( *it );
    if( status != MStatus::kSuccess )
    {
      hkStringBuf   buf;
      buf.printf("Deregistration of node 0x%x failed", it->id());
      status.perror( buf.cString() );
      goto baseQuit;
    }
  }

  // De-register the options node
  status = plugin.deregisterNode( hkNodeOptionsID );
  if( status != MStatus::kSuccess )
  {
    status.perror( "hkNodeOptions deregistration" );
    return status;
  }

  // De-register the legacy filter set options node
  status = plugin.deregisterNode( hkFilterSetOptionsID );
  if( status != MStatus::kSuccess )
  {
    status.perror( "hkMayaFilterSetOptions deregistration" );
    return status;
  }

  // De-register the export command
  status = plugin.deregisterCommand( "hkCmdExportScene" );
  if( status != MStatus::kSuccess )
  {
    status.perror( "hkCmdExportScene deregistration" );
    return status;
  }

  // De-register the export command
  status = plugin.deregisterCommand( "hkCmdWaitForFilterLoad" );
  if( status != MStatus::kSuccess )
  {
    status.perror( "hkCmdWaitForFilterLoad deregistration" );
    return status;
  }
  
   // De-register the export command
  status = plugin.deregisterCommand( "hkCmdGetFileDependencies" );
  if( status != MStatus::kSuccess )
  {
    status.perror( "hkCmdGetFileDependencies deregistration" );
    return status;
  }


  status = plugin.deregisterCommand( "hkCmdImportScene" );
  if( status != MStatus::kSuccess )
  {
    status.perror( "hkCmdImportScene deregistration" );
    return status;
  }


  // De-register the get version command
  status = plugin.deregisterCommand( "hkCmdGetVersion" );
  if( status != MStatus::kSuccess )
  {
    status.perror( "hkCmdGetVersion deregistration" );
    return status;
  }

  hctFilterProcessingUtil::waitOnBackgroundFilterLoad();

baseQuit:
  g_registeredNodes.clear();

  // Cleanup havok memory
  hkSceneExportMemory::baseSystemQuit();

  return status;
}

//COMPAT_REG_ALL

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
