
@ECHO OFF

REM %1 == The name of the project that called the custom build step
REM %2 == HAVOK_MAYA_[VERSION]_PATH (taken from environment variable)
REM %3 == HAVOK_MAYA_SAMPLES_PATH (taken from environment variable)
REM %4 == TARGET_PATH (full path to DLL)
REM %5 == "True" if Convex Decomposition support is included, else "False"
REM %6 == "True" if Cloth support is included, else "False"
REM %7 == "True" if any Destruction support is included, else "False"
REM %8 == Project Dir

REM Save re-execution details in redeploy.bat
set REDEPLOY_FILE=%~dp0redeploy_%~n1.bat
if exist %REDEPLOY_FILE% del %REDEPLOY_FILE%
echo %~dpnx0 %* > %REDEPLOY_FILE%

if not "%~3" == "" goto copysamples

REM Only one variant should copy the shared samples files to avoid redundancy and file access failures
echo %~n1 - Shared sample files copy step disabled for this variant.


:copymodellerfiles

if "%~2" == "" goto nomodellerpath

echo %~n1 - Copying modeller-specific files...

setlocal

rem Don't use /s on top level was we may want to choose sub folders
xcopy scripts\*.* "%~2\scripts\" /y /r >nul
if errorlevel 1 goto failure

xcopy scripts\AETemplates\*.* "%~2\scripts\AETemplates\" /s /y /r >nul
if errorlevel 1 goto failure

xcopy scripts\CgoUtility\*.* "%~2\scripts\CgoUtility\" /s /y /r >nul
if errorlevel 1 goto failure

xcopy scripts\ClothTools\*.* "%~2\scripts\ClothTools\" /s /y /r >nul
if errorlevel 1 goto failure

xcopy scripts\Context\*.* "%~2\scripts\Context\" /s /y /r >nul
if errorlevel 1 goto failure

REM Convex Decomposition
if "%5" == "True" (
	xcopy scripts\convexDecompositionUtility\*.* "%~2\scripts\convexDecompositionUtility\" /y /s /r >nul
	if errorlevel 1 goto failure	
	
	attrib +R "%~2\scripts\convexDecompositionUtility\*.*" /s	
)

xcopy scripts\ConvexHullUtility\*.* "%~2\scripts\ConvexHullUtility\" /s /y /r >nul
if errorlevel 1 goto failure

xcopy scripts\RagDollTools\*.* "%~2\scripts\RagDollTools\" /s /y /r >nul
if errorlevel 1 goto failure

xcopy icons\*.* "%~2\icons\" /s /y /r >nul
if errorlevel 1 goto failure

REM copy is used here instead of xcopy so that the file can be renamed.
if not exist "%~2\plug-ins" mkdir "%~2\plug-ins"
copy %4 "%~2\plug-ins\hctMayaSceneExport.mll" /y >nul

REM Copy debug HCT PDBs...
@setlocal enableextensions enabledelayedexpansion
set PDB_SRC_DIR=%~dp4
set PDB_BASENAME=%~n4
set PDB_DEST_DIR="%~2\plug-ins"
FOR %%a IN ("%PDB_SRC_DIR:~0,-1%") DO SET PDB_SRC_DIR_PARENT=%%~dpa

if %PDB_SRC_DIR%==%PDB_SRC_DIR_PARENT%debug\ if exist "%PDB_SRC_DIR%%PDB_BASENAME%_link.pdb" echo "%PDB_BASENAME%_link.pdb->%PDB_DEST_DIR%"
if %PDB_SRC_DIR%==%PDB_SRC_DIR_PARENT%debug\ if exist "%PDB_SRC_DIR%%PDB_BASENAME%_link.pdb" xcopy "%PDB_SRC_DIR%%PDB_BASENAME%_link.pdb" "%PDB_DEST_DIR%" /s /y /r >nul
endlocal
REM Done copying Debug HCT PDBs

if errorlevel 1 goto failure
echo Files copied to %2

REM Copy the output to file using '>' so that Visual Studio knows that the build step was successful.
echo Files copied to %2 > "%~4.output"

exit /b 0

endlocal 


:copysamples

REM Samples
echo %~n1 - Copying shared sample files...

REM Cloth
if "%6" == "True" (
	xcopy "%~8..\..\..\..\Data\ContentTools\Maya\MayasceneExport\samples\Cloth\*.*" "%3\samples\Cloth\" /d /c /s /y /r >nul
	if errorlevel 1 goto failure
)

REM Cloth
if "%6" == "True" (
	xcopy "%~8..\..\..\..\Data\ContentTools\Maya\MayasceneExport\textures\*.*" "%3\textures\" /d /c /s /y /r >nul
	if errorlevel 1 goto failure
)

REM Cloth
if "%6" == "True" (
	xcopy "%~8..\..\..\..\Data\ContentTools\Maya\MayasceneExport\tutorials\ClothCape\*.*" "%3\tutorials\ClothCape\" /d /c /s /y /r >nul
	if errorlevel 1 goto failure

	xcopy "%~8..\..\..\..\Data\ContentTools\Maya\MayasceneExport\tutorials\ClothRug\*.*" "%3\tutorials\ClothRug\" /d /c /s /y /r >nul
	if errorlevel 1 goto failure

	xcopy "%~8..\..\..\..\Data\ContentTools\Maya\MayasceneExport\tutorials\ClothTrousers\*.*" "%3\tutorials\ClothTrousers\" /d /c /s /y /r >nul
	if errorlevel 1 goto failure

	xcopy "%~8..\..\..\..\Data\ContentTools\Maya\MayasceneExport\tutorials\ClothStandalonePipeline\*.*" "%3\tutorials\ClothStandalonePipeline\" /d /c /s /y /r >nul
	if errorlevel 1 goto failure
)

REM Destruction
if "%7" == "True" (
	xcopy "%~8..\..\..\..\Data\ContentTools\Maya\MayasceneExport\tutorials\Destruction\*.*" "%3\tutorials\Destruction\" /d /c /s /y /r >nul
	if errorlevel 1 goto failure
)

xcopy "%~8..\..\..\..\Data\ContentTools\Maya\MayasceneExport\tutorials\ExportBasics\*.*" "%3\tutorials\ExportBasics\" /d /c /s /y /r >nul
if errorlevel 1 goto failure

xcopy "%~8..\..\..\..\Data\ContentTools\Maya\MayasceneExport\tutorials\MoreOnRigidBodies\*.*" "%3\tutorials\MoreOnRigidBodies\" /d /c /s /y /r >nul
if errorlevel 1 goto failure

xcopy "%~8..\..\..\..\Data\ContentTools\Maya\MayasceneExport\tutorials\PhysicsBasics\*.*" "%3\tutorials\PhysicsBasics\" /d /c /s /y /r >nul
if errorlevel 1 goto failure

xcopy "%~8..\..\..\..\Data\ContentTools\Maya\MayasceneExport\tutorials\RagDollToolbox\*.*" "%3\tutorials\RagDollToolbox\" /d /c /s /y /r >nul
if errorlevel 1 goto failure

xcopy "%~8..\..\..\..\Data\ContentTools\Maya\MayasceneExport\tutorials\ToolchainIntegration\*.*" "%3\tutorials\ToolchainIntegration\" /d /c /s /y /r >nul
if errorlevel 1 goto failure

goto copymodellerfiles


:nomodellerpath

echo WARNING: The relevant HAVOK_MAYA_[VERSION]_PATH env var is not defined. The deployment step has been skipped.

REM Copy the output to file using '>' so that Visual Studio knows that the build step was successful.
echo WARNING: The relevant HAVOK_MAYA_[VERSION]_PATH env var is not defined. The deployment step has been skipped. > "%~4.output"
exit /b 0


:failure

echo Couldn't copy files to %2... 
echo Make sure maya is not running, and that HAVOK_MAYA_[VERSION]_PATH is defined

REM Print an error message for the continuous integration system to detect.
echo ERROR: Custom build step failed.

REM Return an ErrorLevel of 1
exit /b 1

