// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <map>
#include <string>

// Container for utility functions
class hctUtilities
{
public:

    // Structure for use in decomposeMatrix
    struct Decomposition
    {
        MVector     m_translation;  // T
        MQuaternion m_rotation;     // R
        MVector     m_scale;        // S
        MMatrix     m_scaleAndSkew; // M = T*R * scaleAndSkew
        MMatrix     m_skew;         // M = T*R*S * skew
    };

    // Maya's MMatrix->MTransformationMatrix decomposition doesn't work well for general matrices.
    // This properly decomposes an arbitrary matrix into rotation/translation/scale/skew components.
    static void decomposeMatrix( const MMatrix& matrixIn, Decomposition& decompOut );

    // Remove any scale/skew from a Maya matrix
    static void removeScaleAndSkew( const MMatrix& matrixIn, MMatrix& matrixOut );

    // Remove any scale/skew from the current OpenGL modelview matrix
    static void removeGlScaleAndSkew();


    // Get a named color from the Havok physics color editor
    // The alpha component is always set to 1
    static MColor getColor( MString name );

    // Get the local pivot offset of transform node.
    // The export options determine whether this returns the rotate pivot or a zero vector.
    static MStatus getOptionalPivotOffset( const MDagPath& path, MPoint& out );

    // Get the pivot -> world matrix of a transform node ( may be rotation pivot or transform pivot ).
    static MStatus getOptionalPivotWorldTransform( MDagPath path, MMatrix& out );


    // Build a scale matrix to go from world units in object space to pixel units in viewport space
    // Eg: to give manipulators a screen size as opposed to a world size.
    static MMatrix getViewportScaleMatrix(  const M3dView& view, const MMatrix& objToWorld,
                                            const float& worldUnits, const float& pixelUnits );

    // Draw OpenGL shapes
    static void drawCube( float size = 1.0f );
    static void drawCone( float radius = 0.5f, float height = 1.0f, int sides = 8 );
    static void drawCylinder( float radius = 0.5f, float height = 1.0f, int sides = 8 );

    // Generate a polygon mesh from a given nurbs surface, and parent it to the same node
    static MStatus getMeshFromNurbs( const MDagPath& nurbsDagPath, MDagPath& generatedMeshPath );

    // A color cache to avoid repeated script calls
    typedef std::map<std::string, MColor> ColorCache;
    static ColorCache s_colorCache;

  static void HK_CALL getKeyTimes(const MDagPath& dagPath, hkArray<MTime>& keyTimes, MTime startTime, MTime endTime );

};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
