// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/SceneExport/Error/hctSceneExportError.h>

// Error handler
class hkMayaError : public hctSceneExportError
{
public:
    hkMayaError()
    {
        setEnabled( 0x20ad62c3, false );
        setEnabled( 0x651498c4, false );

        setEnabled( 0xf3768206, false ); // pushBack on serialized array.
        setEnabled( 0x34df5494, false ); // chull being slow
    }

    /*virtual*/ int message(Message type, int id, const char* desc, const char* file, int line)
    {
        MString fl(file); fl += "("; fl += line; fl += "): "; fl += desc;
        if (isEnabled(id))
        {
            switch( type )
            {
            case MESSAGE_WARNING:
                MGlobal::displayWarning(fl);
                break;
            case MESSAGE_ERROR:
                MGlobal::displayError(fl);
                break;
            default:
                MGlobal::displayInfo(fl);
                break;
            }

            return hctSceneExportError::message(type, id, desc, file, line);
        }
        else
        {
            return 0;
        }
    }
};

// Container for common maya utility functions
class hctMayaUtilities
{
public:

        /// Retrieves the value from a Maya attribute and stores it in a reflected field.
    static void attributeToClassMember(const MPlug& attributePlug, const hkReflect::Var& field);

        /// Retrieves the value from a reflected field and stores it in a Maya attribute
    static void classMemberToAttribute(const hkReflect::Var& field, MPlug& attributePlug);

        /// Assumes the memory space for the object is already allocated. Extracts every attribute in the maya object which is also
        /// declared as a field in the type and stores it in the object
    static void mayaObjectToClassObject(const MFnDependencyNode& nodeFn, const hkReflect::Var& object);


    //
    // Utility functions
    //

        /// Returns the field of the object corresponding to the attribute name if it is defined and valid,
        /// a null Var otherwise. If can be a field in an embedded struct or a hkVector4 element.
    static hkReflect::Var getField(const char* attributeName, const hkReflect::Var& obj);

    static bool HK_CALL getFilterManagerPath( const char* currentPluginPath, MString& filterManagerPath );

    template<class T>
    static bool getPlugValue(const MObject& o, const char* plugName, T& out)
    {
        MStatus status;
        MPlug plug = MFnDependencyNode(o).findPlug(plugName, &status);
        return (status == MS::kSuccess) && (plug.getValue(out) == MS::kSuccess);
    }

};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
