// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

extern const TCHAR* _HAVOK_FILTERS_REG_KEY;

class hctMayaSceneExportUtilities
{
public:

    // Convert a Maya MMatrix to a Havok hkMatrix4
    static inline void convertMMatrixToHkMatrix4( MMatrix& in, hkMatrix4& out )
    {
        MStatus status;
        HK_ALIGN16(float columnMajor[4][4]);

        // Get the matrix in row major format
        status = in.get( columnMajor );
        if( status != MStatus::kSuccess )
        {
            status.perror( "Error obtaining column major matrix!" );
            return;
        }

        // Set the matrix to be column major
        hkFloat32* cm = (hkFloat32*)&columnMajor[0][0];
        out.set4x4ColumnMajor(cm);
    }

    // Convert a name (returned by a MEL command, for example) into a DAG path
    static inline void nameToDagPath (const MString& name, MDagPath& dagPathOut)
    {
        MSelectionList selList;
        selList.add(name);
        selList.getDagPath(0, dagPathOut);
    }

    // Progress window
    // Maya provides a similar MProgressWindow, but only in v6.0+
    // Maya v2011+ contains a bug where the MProgressWindow is unusably small
    class ProgressWindow
    {
    public:
        ProgressWindow()
        {
            MGlobal::executeCommand( "waitCursor -state on" );
            MGlobal::executeCommand( "window -title \"Havok Export\" -sizeable false -rtf true hkExport;" \
                                        "columnLayout -columnAttach \"both\" 12 -columnWidth 270 -rowSpacing 10;" \
                                            "text -label \"Initializing...\" -align \"left\" hkExportProgressText;" \
                                            "progressBar -maxValue 100 -width 250 -step 1 hkExportProgressBar;" \
                                        "setParent ..;" \
                                     "showWindow;" );
        }
        ~ProgressWindow()
        {
            endProgress();
        }

        void setStatus( MString status )
        {
            if( MGlobal::mayaState() == MGlobal::kInteractive )
            {
                MGlobal::executeCommand( MString("text -edit -label \"") + status + MString("\" hkExportProgressText") );
            }
        }
        void setRange( int min, int max )
        {
            if( MGlobal::mayaState() == MGlobal::kInteractive )
            {
                MGlobal::executeCommand( MString("progressBar -edit -min ") + min + MString(" -max ") + max + MString(" hkExportProgressBar") );
            }
        }
        void setProgress( int val )
        {
            if( MGlobal::mayaState() == MGlobal::kInteractive )
            {
                MGlobal::executeCommand( MString("progressBar -edit -progress ") + val + MString(" hkExportProgressBar") );
            }
        }
        bool isCancelled()
        {
            int windowExists;
            MGlobal::executeCommand( "window -exists hkExport", windowExists );

            return MGlobal::mayaState() == MGlobal::kInteractive && !windowExists;
        }
        void endProgress()
        {
            if( MGlobal::mayaState() == MGlobal::kInteractive )
            {
                int result;
                MGlobal::executeCommand( "window -exists hkExport", result );
                if(result)
                {
                    MGlobal::executeCommand( "waitCursor -state off" );
                    MGlobal::executeCommand( "deleteUI -window hkExport" );
                }
            }
        }
    };
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
