// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// Maya's manipulators are tricky to work with in a non-world space.
// This wrapper takes care of setting up the required callbacks, and
// provides an easier interface.
class hctManipContainer : public MPxManipContainer
{
protected:

    // Manipulator descriptor
    struct ManipDesc
    {
        enum ManipType
        {
            MANIP_TYPE_NONE,
            MANIP_TYPE_POINT,
            MANIP_TYPE_ROTATE,
            MANIP_TYPE_SCALE,
            MANIP_TYPE_DIRECTION,
            MANIP_TYPE_DISTANCE
        };
        hkEnum<ManipType, int> m_manipType;
        MObject m_attribute;

        ManipDesc( ManipType type, const MObject& att )
            : m_manipType(type), m_attribute(att) {}
    };


    hctManipContainer() : m_manipulators(0), m_numManipulators(0) {}
    virtual ~hctManipContainer() { delete [] m_manipulators; }

    // Abstract methods - use virtual array indices
    virtual const ManipDesc* getManipulatorDesc( int ) const = 0;
    virtual MMatrix getManipulatorBaseTransform( int ) const = 0;
    virtual bool getManipulatorVisibility( int ) const = 0;

    // The node we are manipulating
    MObject m_target;

    // Utility for derived classes
    virtual void connectManipToNode( int i, const MObject& node, MStatus& status );

public:

    // Inherited API methods
    virtual MStatus createChildren();
    virtual MStatus connectToDependNode( const MObject& node );
    virtual void draw(  M3dView& view, const MDagPath& path,
        M3dView::DisplayStyle style, M3dView::DisplayStatus status );

    // Snapping - exposed to the context tool
    static bool m_snapRotation;
    static MAngle m_rotationSnapAngle;

protected:

    // The manipulators
    struct ManipItem
    {
        // Each has a number of connections
        struct Connection
        {
            int m_plugIndex;
            int m_manipIndex;
            bool m_initialized;
            Connection() : m_plugIndex(0), m_manipIndex(0), m_initialized(false) {}
        } *m_connections;
        int m_numConnections;

        MDagPath m_path;
        ManipItem() : m_connections(0), m_numConnections(0) {}
        ~ManipItem() { delete [] m_connections; }
    } *m_manipulators;
    int m_numManipulators;

private:

    // Conversion methods
    MManipData manipToPlugTranslationCallback( unsigned int );
    MManipData plugToManipTranslationCallback( unsigned int );

    MManipData manipToPlugRotationCallback( unsigned int );
    MManipData plugToManipRotationCallback( unsigned int );

    MManipData plugToManipCenterCallback( unsigned int );

    MManipData plugToManipDistanceCallback( unsigned int );
    MManipData manipToPlugDistanceCallback( unsigned int );

//  MManipData plugToManipDirectionCallback( unsigned int );
//  MManipData manipToPlugDirectionCallback( unsigned int );
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
