// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/SdkUtils/hctSdkUtils.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/Generic/hctGenericNode.h>

class hctMayaPhysicsDestructionUtilities
{
    public:

        static void initializeDestructionPlugin(MFnPlugin& plugin, MStatus& status);

        static void shutdownDestructionPlugin(MFnPlugin& plugin, MStatus& status);

        static bool nodeHasGizmos(MObject node, MStatus& status);

            /// This 'after scene loaded' callback takes care of versioning the Destruction nodes.
        static void afterSceneLoadCallback(void* clientData);

            /// This 'before scene save' callback updates the version values on all Destruction nodes.
        static void beforeSceneSaveCallback(void* clientData);

            /// Attempts to de-register the given command
        static void deregisterCommand(MFnPlugin& plugin, const MString& commandName, MStatus& status);

    public:

            // The plugin object
        static MObject m_pluginObject;

        static hctGenericNodeHelper m_nodeHelper[ HCT_MAX_NUM_CLASS_ENTRIES ];

            // node registry
        static std::vector<MTypeId> m_destructionNodes;

            // A list of Maya callback IDs.
        static MIntArray m_callbackIds;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
