// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Maya/MayaSceneExport/Nodes/hctLocatorNode.h>

// Havok context: controls display and manipulation of Havok nodes
class hctContext : public MPxSelectionContext
{
public:
    hctContext();
    virtual ~hctContext() {}

    virtual void getClassName( MString& name ) const { name.set( "havokPhysics" ); }
    virtual void toolOnSetup( MEvent& event );
    virtual void toolOffCleanup();

    static bool m_settingsAreGlobal;

private:
    static void update( void* data );

    MCallbackId m_callbackIds[2];
    hctLocatorNode::DisplayType m_rigidBodyDisplayType;
    hctLocatorNode::DisplayType m_constraintDisplayType;
};


// Context creation command
class hctContextCommand : public MPxContextCommand
{
public:
    hctContextCommand() {}
    virtual ~hctContextCommand() {}

    static void* creator() { return new hctContextCommand();    }
    virtual MPxContext* makeObj() { return new hctContext();    }

    virtual MStatus appendSyntax();
    virtual MStatus doEditFlags();
    virtual MStatus doQueryFlags();
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
