// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Maya/MayaSceneExport/hctMayaSceneExport.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/hctMayaOptions.h>

#include <ContentTools/Maya/MayaSceneExport/Exporter/hctMayaSceneExporter.h>

void hctMayaOptions::postConstructor()
{
    // Get the default export options
    hctMayaSceneExporter::Options options;

    // Create attributes with these default values
    MObjectArray attrs;
    {
        MFnTypedAttribute typedFn;
        MFnNumericAttribute numFn;
        MFnUnitAttribute unitFn;
        MFnEnumAttribute enumFn;
        MFnStringData stringData;
        MFnIntArrayData intArrayData;

        // Scene data
        attrs.append( numFn.create( "ExportMeshes",         "EMesh",    MFnNumericData::kBoolean,   options.m_exportMeshes      ) );
        attrs.append( numFn.create( "ExportMaterials",      "EMat",     MFnNumericData::kBoolean,   options.m_exportMaterials   ) );
        attrs.append( numFn.create( "ExportAttributes",     "EAttr",    MFnNumericData::kBoolean,   options.m_exportAttributes  ) );
        attrs.append( numFn.create( "ExportAnnotations",    "EAnno",    MFnNumericData::kBoolean,   options.m_exportAnnotations ) );
        attrs.append( numFn.create( "ExportLights",         "EL",       MFnNumericData::kBoolean,   options.m_exportLights      ) );
        attrs.append( numFn.create( "ExportCameras",        "EC",       MFnNumericData::kBoolean,   options.m_exportCameras     ) );
        attrs.append( numFn.create( "VisibleOnly",          "VO",       MFnNumericData::kBoolean,   options.m_visibleOnly       ) );
        attrs.append( numFn.create( "SelectedOnly",         "SO",       MFnNumericData::kBoolean,   options.m_selectedOnly      ) );

        // Range - default to current range
        enumFn.create( "RangeType", "RT" );
        enumFn.addField( "Current Time", 0 );
        enumFn.addField( "Current Range", 1 );
        enumFn.addField( "Specific Range", 2 );
        enumFn.setDefault( 1 );
        attrs.append( enumFn.object() );
        attrs.append( unitFn.create( "StartTime",           "ST",       options.m_startTime ) );
        attrs.append( unitFn.create( "EndTime",             "ET",       options.m_endTime   ) );

        // Filter Setup
        attrs.append( numFn.create( "UseOptionsFile",       "UOF",      MFnNumericData::kBoolean,   ( options.m_hkoFile != "" ) ) );
        attrs.append( typedFn.create("OptionsFile",         "OF",       MFnData::kString,           stringData.create()));
        attrs.append( numFn.create("UseConfigurationSet",   "UCS",      MFnNumericData::kBoolean,   (options.m_configurationSet != "")));
        attrs.append( typedFn.create("ConfigurationSet",    "CF",       MFnData::kString,           stringData.create()));
        attrs.append( typedFn.create( "FilterSetup",        "FS",       MFnData::kIntArray,         intArrayData.create()       ) );
        attrs.append( typedFn.create( "EnvironmentVariables", "EV",     MFnData::kString,           stringData.create()         ) );

        // Advanced
        attrs.append( numFn.create( "UseRotatePivot",               "RP",           MFnNumericData::kBoolean,   options.m_useRotatePivot    ) );
        attrs.append( numFn.create( "UseOldPhysics",                "OP",           MFnNumericData::kBoolean,   false) ); // DEPRECATED
        attrs.append( numFn.create( "DoNotSplitVertices",           "NSV",          MFnNumericData::kBoolean,   options.m_doNotSplitVertices ) );
        attrs.append( numFn.create( "GetAutoSkinAttachments",       "ASA",          MFnNumericData::kBoolean,   options.m_autoSkinAttachments ) );
        attrs.append( numFn.create( "StoreKeyFrameSamplePoints",    "KFS",          MFnNumericData::kBoolean,   options.m_storeKeyframeSamplePoints ) );
        attrs.append( numFn.create( "ExportTangents",               "EVT",          MFnNumericData::kBoolean,   options.m_exportVertexTangents));
        attrs.append( numFn.create( "ExportVertexAnimations",       "EVA",          MFnNumericData::kBoolean,   options.m_exportVertexAnimations));
    }

    // Add them as dynamic attributes
    MObject obj = thisMObject();
    MFnDependencyNode nodeFn( obj );
    for( unsigned int i=0; i<attrs.length(); ++i )
    {
        nodeFn.addAttribute( attrs[i], MFnDependencyNode::kLocalDynamicAttr );
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
