// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// Base abstract locator node
class hctLocatorNode : public MPxLocatorNode
{
protected:

    hctLocatorNode() {}
    virtual ~hctLocatorNode() {}
    virtual void postConstructor();

    // From MPxLocatorNode
    // Don't hide along with normal locators
    virtual bool excludeAsLocator() const { return false; }

public:

    enum DisplayType
    {
        DISPLAY_TYPE_ALL,       // Always display
        DISPLAY_TYPE_OBJECT,    // Display if the transform object or any children are selected
        DISPLAY_TYPE_DIRECT,    // Display if node is directly selected

        DISPLAY_TYPE_LAST
    };

    // Determine whether a node should be displayed,
    // based on the current selection and a display type
    static bool shouldDisplay( const MObject& node, DisplayType displayType );

    // Provide bounding box info to give cues for frame selection
    virtual bool isBounded() const HK_OVERRIDE;
    virtual MBoundingBox boundingBox() const HK_OVERRIDE;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
