// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Maya/MayaSceneExport/hctMayaSceneExport.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/hctLocatorNode.h>


void hctLocatorNode::postConstructor()
{
    MFnDagNode nodeFn( thisMObject() );

    // Don't show inherited locator attribs in the channel box
#if MAYA_API_VERSION >= 650
    nodeFn.findPlug( localPositionX ).setChannelBox( false );
    nodeFn.findPlug( localPositionY ).setChannelBox( false );
    nodeFn.findPlug( localPositionZ ).setChannelBox( false );
#endif

#if MAYA_API_VERSION >= 700
    nodeFn.findPlug( localScaleX ).setChannelBox( false );
    nodeFn.findPlug( localScaleY ).setChannelBox( false );
    nodeFn.findPlug( localScaleZ ).setChannelBox( false );
#endif
}


/*static*/ bool hctLocatorNode::shouldDisplay( const MObject& node, DisplayType displayType )
{
    if (displayType == DISPLAY_TYPE_ALL)
    {
        return true;
    }

    MDagPath nodePath;
    MDagPath::getAPathTo( node, nodePath );

    MSelectionList selectionList;
    MGlobal::getActiveSelectionList( selectionList );

    switch( displayType )
    {
    case DISPLAY_TYPE_OBJECT:
        {
            MDagPath transformNodePath;
            MDagPath::getAPathTo( nodePath.transform(), transformNodePath );
            if( selectionList.hasItem( transformNodePath ) )
            {
                return true;
            }

            unsigned int numShapes;
            transformNodePath.numberOfShapesDirectlyBelow( numShapes );
            for( unsigned int i=0; i<numShapes; ++i )
            {
                MDagPath shapePath = transformNodePath;
                shapePath.extendToShapeDirectlyBelow(i);
                if( selectionList.hasItem( shapePath ) )
                {
                    return true;
                }
            }
        }
        break;

    case DISPLAY_TYPE_DIRECT:
        {
            return selectionList.hasItem( nodePath );
        }
        break;
    }

    return false;
}

bool hctLocatorNode::isBounded() const
{
    return false;
}

MBoundingBox hctLocatorNode::boundingBox() const
{
    return MBoundingBox();
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
