// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Maya/MayaSceneExport/Nodes/hctLocatorNode.h>


// Shape node: stores collision volume information
class hctShapeNode : public hctLocatorNode
{
public:

    HK_DECLARE_MAYA_NODE( hctShapeNode, "hkNodeShape", hkNodeShapeID );
    static MStatus initialize();

    // Callbacks for upgrading scenes
    static void registerCallbacks();
    static void unregisterCallbacks();

private:

    static void beforeSaveCallback (void*);
    static MCallbackId m_beforeSaveCallbackId;

    static void afterLoadCallback (void*);
    static MCallbackId m_afterLoadCallbackId;


    //
    // Attributes
    //

    // Group name
    static MObject m_hkType;

    static MObject m_shapeType;
    static MObject m_changeExtraRadius;
    static MObject m_extraRadius;

    // DEPRECATED
    static MObject m_convexRadius_Deprecated;

    // INTERNAL
    static MObject m_version;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
