// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Maya/MayaSceneExport/hctMayaSceneExport.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/Shape/hctShapeNode.h>

// Callback ID
MCallbackId hctShapeNode::m_beforeSaveCallbackId;
MCallbackId hctShapeNode::m_afterLoadCallbackId;

// Attributes
MObject hctShapeNode::m_hkType;
MObject hctShapeNode::m_shapeType;
MObject hctShapeNode::m_changeExtraRadius;
MObject hctShapeNode::m_extraRadius;
MObject hctShapeNode::m_convexRadius_Deprecated;
MObject hctShapeNode::m_version;

#define CURRENT_VERSION 7000
#define DEFAULT_VERSION 0


MStatus hctShapeNode::initialize()
{
    MStatus status = MStatus::kSuccess;

    // hkType
    {
        MFnTypedAttribute typedFn;
        MFnStringData stringFn;
        m_hkType = typedFn.create( "hkType", "hkt", MFnData::kString, stringFn.create( "hkShape" ), &status );
        if( !status ) MGlobal::displayError( "Couldn't create hkType attr" );
        typedFn.setWritable( false );
        typedFn.setHidden( true );
        addAttribute( m_hkType );
    }

    // Shape type
    {
        MFnEnumAttribute enumFn;
        m_shapeType = enumFn.create( "shapeType", "st", 0, &status );
        if( !status ) MGlobal::displayError( "Couldn't create shape type attr" );
        enumFn.addField( "Hull",    1 );
        enumFn.addField( "Box",     2 );
        enumFn.addField( "Sphere",  3 );
        enumFn.addField( "Cylinder",4 );
        enumFn.addField( "Capsule", 5 );
        enumFn.addField( "Mesh",    6 );
        enumFn.setDefault( 1 );
        enumFn.setKeyable( true );
        addAttribute( m_shapeType );
    }

    // Change Extra Radius
    {
        MFnNumericAttribute numFn;
        m_changeExtraRadius = numFn.create( "changeExtraRadius", "cer", MFnNumericData::kBoolean, 0, &status );
        if( !status ) MGlobal::displayError( "Couldn't create changeExtraRadius attr" );
        numFn.setConnectable( false );
        numFn.setKeyable( true );
        addAttribute( m_changeExtraRadius );
    }

    // Extra radius (Linear) (default 5 cm)
    {
        MFnUnitAttribute unitFn;
        m_extraRadius = unitFn.create( "extraRadius", "er", MFnUnitAttribute::kDistance, 5.0, &status );
        if( !status ) MGlobal::displayError( "Couldn't create extra radius attr" );
        unitFn.setMin( 0.0 );
        unitFn.setKeyable( true );
        addAttribute( m_extraRadius );
        unitFn.setKeyable ( true );
        unitFn.setHidden ( false );
    }

    /*
    ** Deprecated attributes
    */

    // Convex radius (should have been Linear)
    {
        MFnNumericAttribute numFn;
        m_convexRadius_Deprecated = numFn.create( "convexRadius", "cr", MFnNumericData::kDouble, 0, &status );
        if( !status ) MGlobal::displayError( "Couldn't create convex radius attr" );
        numFn.setMin( 0.0 );
        numFn.setKeyable( true );
        addAttribute( m_convexRadius_Deprecated );
        numFn.setKeyable ( false );
        numFn.setHidden ( true );
    }

    /*
    ** Internal attributes
    */

    // Version
    {
        MFnNumericAttribute numFn;
        m_version = numFn.create( "version", "ver", MFnNumericData::kInt, 0, &status );
        if( !status ) MGlobal::displayError( "Couldn't create version attr" );
        numFn.setDefault( DEFAULT_VERSION );
        addAttribute( m_version );
        numFn.setKeyable ( false );
        numFn.setHidden ( true );
    }

    return status;
}

//
// Callbacks for upgrading scenes
//


/*static*/ void hctShapeNode::beforeSaveCallback (void*)
{
    // Update the version of all shape nodes to the latest

    MItDag dagIterator( MItDag::kDepthFirst, MFn::kLocator);

    for ( ; !dagIterator.isDone(); dagIterator.next())
    {
        MDagPath dagPath; dagIterator.getPath(dagPath);

        MFnDagNode node (dagPath);

        if (node.typeId()!=hkNodeShapeID)
        {
            continue;
        }

        MPlug versionPlug = node.findPlug(m_version);
        versionPlug.setValue(CURRENT_VERSION);

    }
}


/*static*/ void hctShapeNode::afterLoadCallback (void*)
{
    // Check all loaded shape nodes and if the version is old, upgrade
    MItDag dagIterator( MItDag::kDepthFirst, MFn::kLocator);

    for ( ; !dagIterator.isDone(); dagIterator.next())
    {
        MDagPath dagPath; dagIterator.getPath(dagPath);

        MFnDagNode node (dagPath);

        if (node.typeId()!=hkNodeShapeID)
        {
            continue;
        }

        MPlug versionPlug = node.findPlug(m_version);
        int sceneVersion;
        versionPlug.getValue(sceneVersion);

        if (sceneVersion<4000)
        {
            // Upgrade to 4.0
            MPlug convexRadius = node.findPlug (m_convexRadius_Deprecated);
            MPlug extraRadius = node.findPlug (m_extraRadius);
            MPlug changeExtraRadius = node.findPlug (m_changeExtraRadius);

            // Copy "convexRadius" to "extraRadius"
            double radius;
            convexRadius.getValue(radius);
            extraRadius.setValue(radius);
            // Enable "extraRadius"
            changeExtraRadius.setValue(true);
        }

    }
}

/*static*/ void hctShapeNode::registerCallbacks()
{
    m_beforeSaveCallbackId = MSceneMessage::addCallback (MSceneMessage::kBeforeSave, &beforeSaveCallback, NULL);
    m_afterLoadCallbackId = MSceneMessage::addCallback (MSceneMessage::kAfterOpen, &afterLoadCallback, NULL);
}

/*static*/ void hctShapeNode::unregisterCallbacks()
{
    MMessage::removeCallback (m_beforeSaveCallbackId);
    MMessage::removeCallback (m_afterLoadCallbackId);
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
