// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Maya/MayaSceneExport/Nodes/hctLocatorNode.h>
#include <ContentTools/Maya/MayaSceneExport/Utilities/hctManipContainer.h>


// Rigid body node: stores dynamics information
class hctScriptedFractureNode : public hctLocatorNode
{
    public:

        class CmdOpenScript : public MPxCommand
        {
            public:

                /// Factory
                static HK_INLINE void* creator() { return new hctScriptedFractureNode::CmdOpenScript; }

                /// Command syntax
                static MSyntax getCommandSyntax();

                /// Loads and parses script, then adds custom attributes to the node.
                MStatus doIt( const MArgList& args );
        };

        class CmdBuildUi : public MPxCommand
        {
            public:

                /// Factory
                static HK_INLINE void* creator() { return new hctScriptedFractureNode::CmdBuildUi; }

                /// Command syntax
                static MSyntax getCommandSyntax();

                /// Loads and parses script, then adds custom attributes to the node.
                MStatus doIt( const MArgList& args );
        };

    public:

        static MStatus initialize();

        static HK_INLINE void* creator()    {   return new hctScriptedFractureNode; }

        MStatus shouldSave(const MPlug& plug, bool& isSaving);

        virtual void draw(M3dView& view, const MDagPath& path, M3dView::DisplayStyle style, M3dView::DisplayStatus displayStatus);
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
