// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Maya/MayaSceneExport/Nodes/hctLocatorNode.h>
#include <ContentTools/Maya/MayaSceneExport/Utilities/hctManipContainer.h>


// Rigid body node: stores dynamics information
class hctRigidBodyNode : public hctLocatorNode
{
public:

    HK_DECLARE_MAYA_NODE( hctRigidBodyNode, "hkNodeRigidBody", hkNodeRigidBodyID );
    static MStatus initialize();

    hctRigidBodyNode() {}
    virtual ~hctRigidBodyNode() {}

    // Draw the locator
    virtual void draw( M3dView& view, const MDagPath& path,
        M3dView::DisplayStyle displayStyle, M3dView::DisplayStatus displayStatus );


    // Common display type
    static DisplayType m_displayType;

    //
    // Attributes
    //

    // Group name
    static MObject m_hkType;

    static MObject m_mass;
    static MObject m_changeCenterOfMass;
    static MObject m_centerOfMass;
    static MObject m_changeInertiaTensor;
    static MObject m_inertiaTensor;
    static MObject m_scaleInertiaTensor;
    static MObject m_inertiaTensorScale;
    static MObject m_friction;
    static MObject m_restitution;

    // optional advanced ones
    static MObject m_changeQualityType;
    static MObject m_qualityType;
    static MObject m_changeSolverDeactivation;
    static MObject m_solverDeactivation;
    static MObject m_changeCollisionFilterInfo;
    static MObject m_collisionFilterInfo;
    static MObject m_changeRigidBodyDeactivatorType;
    static MObject m_rigidBodyDeactivatorType;
    static MObject m_changeMaxAngularVelocity;
    static MObject m_maxAngularVelocity;
    static MObject m_changeMaxLinearVelocity;
    static MObject m_maxLinearVelocity;
    static MObject m_changeLinearDamping;
    static MObject m_linearDamping;
    static MObject m_changeAngularDamping;
    static MObject m_angularDamping;
    static MObject m_changeAllowedPenetrationDepth;
    static MObject m_allowedPenetrationDepth;

private:

    // Get bounding box of first sibling mesh
    static void getMeshBoundingBox( const MDagPath& path, MBoundingBox& bb );
};


// Rigid body manipulator
class hctRigidBodyManip : public hctManipContainer
{
public:
    HK_DECLARE_MAYA_NODE( hctRigidBodyManip, "hkNodeRigidBodyManip", hkNodeRigidBodyManipID );
    enum
    {
        MANIP_CENTER_OF_MASS,
        MANIP_INERTIA_TENSOR
    };

    const ManipDesc* getManipulatorDesc( int id ) const;
    MMatrix getManipulatorBaseTransform( int id ) const;
    bool getManipulatorVisibility( int id ) const;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
