// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Maya/MayaSceneExport/hctMayaSceneExport.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/LocalFrame/hctLocalFrameNode.h>
#include <ContentTools/Maya/MayaSceneExport/Utilities/hctUtilities.h>

// Statics
MObject hctLocalFrameNode::m_hkType;
MObject hctLocalFrameNode::m_localFrameName;
MObject hctLocalFrameNode::m_localFrameGroup;

hctLocatorNode::DisplayType hctLocalFrameNode::m_displayType = hctLocatorNode::DISPLAY_TYPE_OBJECT;

MStatus hctLocalFrameNode::initialize()
{
    MStatus status = MStatus::kSuccess;

    MFnTypedAttribute   typedFn;
    MFnStringData       stringFn;

    // hkType
    {
        MFnStringData stringFnType;
        m_hkType = typedFn.create( "hkType", "hkt", MFnData::kString, stringFnType.create( "hkLocalFrame" ), &status );
        if( !status ) MGlobal::displayError( "Couldn't create hkType attr" );
        typedFn.setWritable( false );
        typedFn.setHidden( true );
        addAttribute( m_hkType );
    }

    const char* defaultString = "";

    // localFrameName
    {
        m_localFrameName = typedFn.create( "localFrameName", "lfnm", MFnData::kString, stringFn.create(defaultString), &status );
        if ( !status ) MGlobal::displayError( "Couldn't create local frame name attr" );
        typedFn.setWritable( true );
        addAttribute( m_localFrameName );
    }

    // localFrameGroup
    {
        m_localFrameGroup = typedFn.create( "localFrameGroup", "gr", MFnData::kString, stringFn.create(defaultString), &status );
        if ( !status ) MGlobal::displayError( "Couldn't create local frame group name attr" );
        typedFn.setWritable( true );
        addAttribute( m_localFrameGroup );
    }

    // Allow manipulation
    MTypeId id = typeId();
    MPxManipContainer::addToManipConnectTable( id );

    return status;
}

void hctLocalFrameNode::draw( M3dView& view, const MDagPath&, M3dView::DisplayStyle, M3dView::DisplayStatus )
{
    // Check if it should be displayed
    MObject node = thisMObject();
    if( !shouldDisplay( node, m_displayType ) )
    {
        return;
    }

    // Begin OpenGL
    view.beginGL();
    glPushAttrib( GL_CURRENT_BIT | GL_ENABLE_BIT | GL_LINE_BIT | GL_POLYGON_BIT );
    glPushMatrix();

    view.setDrawColor( hctUtilities::getColor( "LocalFrameLabel" ) );
    view.drawText( "LF", MPoint::origin, M3dView::kCenter );

    // End OpenGL
    glPopMatrix();
    glPopAttrib();
    view.endGL();
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
