// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/Uuid/hkUuid.h>

#include <ContentTools/Common/SdkUtils/ClassHierarchy/hctClassHierarchyUtil.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/hctLocatorNode.h>


class hctGenericNodeHelper
{
    public:

        struct Attribute
        {
            Attribute(const char* n) : m_name(n)
            {
            }

            const char* m_name;
            MObject     m_object;
        };

        struct Gizmo
        {
            Gizmo(const hkGizmoAttribute& g, const Attribute& a) : m_gizmo(g), m_attribute(a) {}

            hkGizmoAttribute m_gizmo;
            Attribute        m_attribute;
        };

    public:

        hctGenericNodeHelper() : m_classNumber(-1)
        {
        }

        MStatus initialize();

        void setId(int i)
        {
            m_classNumber = i;
        }

        void createAttributesFromParamGroup(hkAttributeHideCriteria::Types hideCriteria, const hctClassHierarchyUtil::ParamGroup* group, hkOstream& streamWriter);

        // This method will force all class members to get saved to the Maya scene file, even if their value is the default value.
        // (Normally Maya won't save attributes whose value is the default value.)
        MStatus shouldSave(const MPlug& plug, bool& forceSaving);

        void draw(MObject node, M3dView& view, const MDagPath& path, M3dView::DisplayStyle style, M3dView::DisplayStatus displayStatus, int numRecursionLeft = 10);

        void drawStoredGizmos(MObject node, M3dView& view, const MDagPath& dagPath, bool wireframe) const;

        void recursivelyDrawLinkedNodes(MObject node, M3dView& view, const MDagPath& dagPath, M3dView::DisplayStyle style, int numRecursionLeft);

    protected:

        void createAttributesFromParamGroupRecursively(hkAttributeHideCriteria::Types hideCriteria, const hctClassHierarchyUtil::ParamGroup* group, const std::stringstream& indentIn, hkOstream& streamWriter);

        void createUnderReviewNotificationGroup(const hkReflect::Type* klass, hkOstream& streamWriter);
        void createUnderReviewNotificationText(hkOstream& streamWriter);
        void createHelpGroup(const hkReflect::Type* klass, hkOstream& streamWriter);
        void createHelpButton(const hkReflect::Type* klass, hkOstream& streamWriter);

        static void setInt32MinMaxValues (const hkReflect::Type* member, MFnNumericAttribute& numFn);
        static void setFloatMinMaxValues (const hkReflect::Type* member, MFnUnitAttribute& unitFn, hkReal unitConversionFactor);
        static void setFloatMinMaxValues (const hkReflect::Type* member, MFnNumericAttribute& numFn);
        static void setVectorMinMaxValues(const hkReflect::Type* member, MFnNumericAttribute& numFn, hkReal unitConversionFactor);

        static hkReal getDistanceUnitConversionFactor();
        static hkReal getAngleUnitConversionFactor();

    public:

        int                    m_classNumber;
        std::vector<Attribute> m_attributes;
        std::vector<Gizmo>     m_gizmos;

            // Show flag - exposed to the context tool
        static bool m_showGizmos;
};


template<int TYPE_ID_OFFSET>
class hctGenericNode : public MPxNode
{
    public:

        static hctGenericNodeHelper& getHelper()
        {
            return hctMayaPhysicsDestructionUtilities::m_nodeHelper[TYPE_ID_OFFSET];
        }

        static MStatus initialize()
        {
            return getHelper().initialize();
        }

        static void* creator()
        {
            return new hctGenericNode<TYPE_ID_OFFSET>;
        }
};


template<int TYPE_ID_OFFSET>
class hctGenericLocatorNode : public hctLocatorNode
{
    public:

        static hctGenericNodeHelper& getHelper()
        {
            return hctMayaPhysicsDestructionUtilities::m_nodeHelper[TYPE_ID_OFFSET];
        }

        static MStatus initialize()
        {
            return getHelper().initialize();
        }

        void postConstructor() HK_OVERRIDE
        {
            MObject oNode = thisMObject();
            MFnDependencyNode fnNode(oNode);

            for (int i = 0; i < int(fnNode.attributeCount()); i++)
            {
                MObject attrObject = fnNode.attribute(i);
                MFnAttribute attr(attrObject);
                const char* attributeName = attr.name().asChar();

                if ( hkString::strCmp(attributeName, "uuid") == 0 )
                {
                    // Get current value
                    MPlug plug          (oNode, attrObject);
                    MString szCrtVal;   plug.getValue(szCrtVal);
                    hkUuid uuid;        uuid.setFromFormattedString(szCrtVal.asChar());

                    if ( uuid == hkUuid::getNil() )
                    {
                        // Auto-generate unique UUIDs
                        uuid.setRandom();
                        hkStringBuf strb;   uuid.toString(strb);
                        MString mstr        (strb.cString());

                        plug.setValue(mstr);
                    }
                }
            }
        }

        static void* creator()
        {
            hctLocatorNode* retNode = new hctGenericLocatorNode<TYPE_ID_OFFSET>;
            return retNode;
        }

        MStatus shouldSave(const MPlug& plug, bool& isSaving)
        {
            return getHelper().shouldSave(plug, isSaving);
        }

        virtual void draw(M3dView& view, const MDagPath& path, M3dView::DisplayStyle style, M3dView::DisplayStatus displayStatus)
        {
            getHelper().draw(thisMObject(), view, path, style, displayStatus);
        }
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
